#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд',
  comment => 'Заменяет пустые ФИО в кампаниях на ФИО из настроек главного представителя',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

$log->out('Fetching campaigns with empty FIO');
my $cids = get_one_column_sql(PPC_HEAVY, q/
    SELECT co.cid
    FROM camp_options co
    INNER JOIN campaigns c ON co.cid = c.cid
    WHERE
        LENGTH(co.FIO) = 0
        AND c.statusEmpty = "No"
/);
$log->out('Got ' . @$cids . ' campaigns with empty FIO');

while (my @cid_packet = splice @$cids, 0, 1_000) {
    $log->out('Fixing packet of ' . @cid_packet . ' cids: ', \@cid_packet);
    do_sql(PPC, [q/
        UPDATE camp_options co
        INNER JOIN campaigns c ON co.cid = c.cid
        INNER JOIN users u ON c.uid = u.uid
        SET co.FIO = u.FIO
        WHERE
            LENGTH(co.FIO) = 0
            AND c.statusEmpty = "No"
    /, 'AND', {'co.cid' => \@cid_packet}]);
}

$log->out('FINISH');
