#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '2 минуты',
  comment => 'Исправляет склеившиеся фразы с двумя парами кавычек',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use PhraseText qw/get_phrase_props/;
use Lang::Unglue qw/unglue_phrases_lite/;
use Yandex::HashUtils qw/hash_copy/;
use Phrase qw/mass_add_update_phrase/;
use BannersCommon qw/get_banners/;
use MailNotification;
use RBAC2::Extended;
use RBACDirect;
use Primitives;

use utf8;
use open ':std' => ':utf8';

my $UID = 0;

# заранее выбранные id проблемных фраз
my @bids_ids = qw/
681543229
681427681
681294366
681294365
681294364
681192567
681192566
681192565
681192564
681028129
680468225
680431734
680407114
680407113
680407112
680407111
680407110
680407109
680229021
/;

$log->out('START');

my $bids = get_all_sql(PPC_HEAVY, [q/SELECT bi.*, c.uid FROM bids bi INNER JOIN campaigns c USING(cid) WHERE phrase like '%"%"%"%"%' AND/, {'bi.id' => \@bids_ids}]);
$log->out('Found ' . scalar(@$bids) . ' phrases');
Tools::_save_vars(undef, $UID);

my $rbac = get_singleton RBAC2::Extended();
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);

MailNotification::save_UID_rbac($UID, $rbac);

for my $data(@$bids) {
    my $text = $data->{phrase};
    if ($text =~ /^(".+?")\s+"(.+?)"$/) {
        my $new_text = $1;

        $log->out($data);

        my $new_props = get_phrase_props($new_text);

        # проверяем, что фразам с учётом изменения не требуется расклейка
        my $other_phrases = get_one_column_sql(PPC, ['SELECT phrase FROM bids', WHERE => {id__ne => $data->{id}, cid => $data->{cid}, bid => $data->{bid}}]);
        if ($other_phrases && @$other_phrases) {
            my $res = unglue_phrases_lite([@$other_phrases, $new_text]);
            $log->die('ERROR: phrases need unglue :(') if $res->{unglued};
        }

        my $phrase = $data;
        hash_copy $phrase, $new_props, qw/phrase norm_phrase numword/;
        $phrase->{yaca} = !$phrase->{numword};
        $phrase->{AutoBroker} = ($phrase->{AutoBroker} eq 'Yes') ? 1 : 0;
        my $norm2id = mass_add_update_phrase([$phrase]);
        my @new_ids = values %$norm2id;
        $log->out('New bids ids: ', \@new_ids);
        do_update_table(PPC, 'phrases', {statusBsSynced => 'No'}, where => {bid => $data->{bid}});
    } else {
        $log->die("Bad text: $text");
    }
}

$log->out('FINISH');
