#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'порядка 3 часов',
        comment => q[
            Добавляем новые поля в таблицы с фразами(в статистике)
            
            Как запускать:
            20120618_add_imprint_in_stat_phrases.pl 1 2 3 4 5 6 # номера ppcstat
        ],
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

foreach my $inst (map {/^(ppcstat:)?(\d+)$/ ? $2 : ()} @ARGV) {

    $log->out("ppcstat:$inst start");
    my $dbh = connect_db(get_db_config("ppcstat:$inst"));
    add_columns($dbh, $inst);
    disconnect_db($dbh);
    $log->out("ppcstat:$inst finish");
}

sub add_columns {
 
    my ($dbh, $instance) = @_;

    my $alter = q[
        ALTER TABLE %s
        ADD COLUMN imprint bigint unsigned NOT NULL DEFAULT 0,
        ADD COLUMN orig_phrase text];

    my $tables = get_one_column_sql($dbh, q[SHOW TABLES IN ppcstat_phrases LIKE 'order_phrases_%']);
    my ($q, $total) = (0, scalar @$tables);
    
    $dbh->{HandleError} = sub {return 1};
    foreach my $t (map {"ppcstat_phrases.${_}"} @$tables) {

        eval {
            do_sql($dbh, sprintf $alter, $t)
        };

        $log->out("ppcstat:$instance $t: " . $@) if $@;
        $log->out("ppcstat:$instance $q/$total tables done") unless ++$q % 1000;
    }
}
