#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 9 часов, перезапускаем в случае падения',
  comment => 'Исправляем нулевые цены на поиске в кампаниях со стратегиями, отличными от отдельного размещения',
}

=cut

=head1 COMMENT

m pr:ppc:heavy 'select count(*) from bids bi inner join campaigns c ON bi.cid=c.cid left join camp_options co ON bi.cid=co.cid where     bi.price < 0.01     and (co.strategy is null or co.strategy <> "different_places") and c.autobudget = "No" and bi.modtime >= "2012-06-11"'
+----------+
| count(*) |
+----------+
|  5084847 | 
+----------+

real    10m6.670s
user    0m0.184s
sys     0m0.023s


$ m pr:ppc:heavy 'select count(*) from bids_arc bi inner join campaigns c ON bi.cid=c.cid left join camp_options co ON bi.cid=co.cid where     bi.price < 0.01     and (co.strategy is null or co.strategy <> "different_places") and c.autobudget = "No" and bi.modtime >= "2012-06-13 14:00"'

+----------+
| count(*) |
+----------+
|    44376 | 
+----------+

real    9m13.624s
user    0m0.191s
sys     0m0.014s

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Currencies qw/$MIN_PRICE/;

use utf8;

my $PACKET_SIZE = 10_000;
my $SLEEP_BETWEEN_PACKETS = 60;

my %tables = (
# по bids миграция уже отработала
#    bids => 'id',
    bids_arc => 'cid',
);

GetOptions(
    'packet-size=i' => \$PACKET_SIZE,
    'sleep=i' => \$SLEEP_BETWEEN_PACKETS,
);

$log->out('START');

while(my($table, $key) = each %tables) {
    $log->out("Fetching data to fix for table $table");
    my $data_to_fix = get_all_sql(PPC_HEAVY, qq!
        SELECT bi.id, bi.bid, bi.cid
        FROM $table bi
        INNER JOIN campaigns c ON bi.cid = c.cid
        LEFT JOIN camp_options co ON bi.cid = co.cid
        WHERE
            bi.price < ?
            AND (co.strategy IS NULL OR co.strategy <> 'different_places')
            AND c.autobudget = "No"
            AND bi.modtime >= "2012-06-13 14:00"
    !, $MIN_PRICE);

    $log->out('Got ' . scalar(@$data_to_fix) . " records to fix in table $table");

    my $updated_rows_cnt_total = 0;
    while (my @packet = splice @$data_to_fix, 0, $PACKET_SIZE) {
        $log->out("Processing new packet for table $table with " . scalar(@packet) . ' records');
        $log->out($_) for @packet;

        my @ids = map {$_->{$key}} @packet;
        my $updated_rows_cnt = do_sql(PPC, [qq!
            UPDATE $table bi
            INNER JOIN campaigns c ON bi.cid = c.cid
            LEFT JOIN camp_options co ON bi.cid=co.cid
            SET bi.price = ?, bi.statusBsSynced = 'No', bi.modtime = bi.modtime, c.LastChange = c.LastChange
            WHERE
                bi.price < ?
                AND (co.strategy IS NULL OR co.strategy <> 'different_places')
                AND c.autobudget = "No"
                AND bi.modtime >= "2012-06-13 14:00"
                AND
        !, {"bi.$key" => \@ids}], $MIN_PRICE, $MIN_PRICE);
        $log->out(int($updated_rows_cnt). " rows updated in table $table");
        $updated_rows_cnt_total += $updated_rows_cnt;

        $log->out("Sleeping for $SLEEP_BETWEEN_PACKETS seconds");
        sleep($SLEEP_BETWEEN_PACKETS);
    }
    $log->out("Total $updated_rows_cnt_total rows updated in table $table");
}

$log->out('FINISH');
