#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'порядка 2.5 - 3 часа',
        comment => q[
            Вычисление хеш функции от фраз в статистике.
            Сохранение преобразованных фраз в БД.
            
            Как запускать:
            20120621_insert_imprint_for_stat_phrases.pl 1 2 3 4 5 6 # номера ppcstat
        ],
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use DBStat;
use Tools;

use constant MAX_ROWS => 10000;

foreach my $inst (map {/^(ppcstat:)?(\d+)$/ ? $2 : ()} @ARGV) {

    $log->out("ppcstat:$inst start");
    my $dbh = connect_db(get_db_config("ppcstat:$inst"));
    fill_phrases($dbh, $inst);
    disconnect_db($dbh);
    $log->out("ppcstat:$inst finish");
}

sub fill_phrases {
 
    my ($dbh, $instance) = @_;

    my $insert = q[
        INSERT INTO %s (PhraseID, imprint, orig_phrase) VALUES %%s
        ON DUPLICATE KEY UPDATE imprint = VALUES(imprint), 
        orig_phrase = VALUES(orig_phrase)];
    
    my $sql = q[SELECT PhraseID, phrase FROM %s];

    my $tables = get_one_column_sql($dbh, q[SHOW TABLES IN ppcstat_phrases LIKE 'order_phrases_%']);
    my ($q, $total) = (0, scalar @$tables);
    
    $dbh->{HandleError} = sub {return 1};
    foreach my $t (map {"ppcstat_phrases.${_}"} @$tables) {

        my $sth = exec_sql($dbh, sprintf $sql, $t);
        my @phrases;
        my $idx = 0;
        while (my ($id, $phrase) = $sth->fetchrow_array) {
            my $nph = DBStat::_get_orig_phrase($phrase);
            push @phrases, [$id, Tools::url_hash_utf8($nph), $nph];
            if (++$idx > MAX_ROWS) {
                do_mass_insert_sql($dbh, sprintf($insert, $t), \@phrases);
                ($idx, @phrases) = (0, ());
            }
        }
        do_mass_insert_sql($dbh, sprintf($insert, $t), \@phrases) if $idx;
        
        $log->out("ppcstat:$instance $q/$total tables done") unless ++$q % 1000;
    }
}
