#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '15 минут',
  comment => 'исправляем невалидные регионы показа, возникшие в результате недостаточной проверки',
}

=cut

=head2 EXAMPLE

$ m pr:ppc:heavy 'select bid,geo,lastchange from phrases where geo is not null and length(geo) > 0 and Geo not regexp "^[ 0-9\-]"'
+----------+------------------------------------------------------------------------------------+---------------------+
| bid      | geo                                                                                | lastchange          |
+----------+------------------------------------------------------------------------------------+---------------------+
| 17067864 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-05 16:33:26 | 
| 23604298 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-14 17:19:38 | 
| 23704547 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-15 18:29:31 | 
| 23876459 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-17 20:32:56 | 
| 24120115 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-22 17:13:47 | 
| 24238889 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-24 13:10:12 | 
| 24260730 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-24 16:54:26 | 
| 24531890 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-03-31 18:37:26 | 
| 25050324 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-04-07 09:45:53 | 
| 25174860 | [LAPI.RegionInfo;@4ab2f                                                            | 2011-04-08 17:10:04 | 
| 25174880 | [LAPI.RegionInfo;@c26b16                                                           | 2011-04-08 17:12:43 | 
| 25175304 | [LAPI.RegionInfo;@ff22ed                                                           | 2011-04-08 17:17:56 | 
| 25175317 | [LAPI.RegionInfo;@f429d7                                                           | 2011-04-08 17:18:43 | 
| 25175332 | [LAPI.RegionInfo;@1e708b2                                                          | 2011-04-08 17:19:30 | 
| 25175622 | [LAPI.RegionInfo;@705d28                                                           | 2011-04-08 17:24:48 | 
| 25182095 | [LAPI.RegionInfo;@ec115b                                                           | 2011-04-08 19:14:26 | 
| 25182499 | [LAPI.RegionInfo;@f429d7                                                           | 2011-04-08 19:19:41 | 
| 25348507 | [LAPI.RegionInfo;@1fbc355                                                          | 2011-04-12 16:59:29 | 
| 25610772 | [LAPI.RegionInfo;@ad2c30                                                           | 2011-04-15 17:06:46 | 
| 25652863 | [Lcom.yandex.API.RegionInfo;@19cb0f1                                               | 2011-04-16 13:51:26 | 
| 25725801 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-04-18 17:15:31 | 
| 26327120 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-04-27 10:50:12 | 
| 26779057 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-05-24 18:41:28 | 
| 26781887 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-06-15 17:41:26 | 
| 26784367 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-06-15 17:41:30 | 
| 27896964 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-05-24 18:41:31 | 
| 27897152 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-05-24 18:41:35 | 
| 27899091 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-05-24 18:44:29 | 
| 28947493 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-06-08 17:33:44 | 
| 28948598 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-09 10:16:37 | 
| 28948642 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-27 11:08:17 | 
| 28949563 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-06-08 17:33:44 | 
| 29391608 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-06-16 12:47:47 | 
| 32380583 | [213, 1]                                                                           | 2011-07-13 15:12:03 | 
| 32380584 | [213, 1]                                                                           | 2011-07-13 15:12:03 | 
| 34871880 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-08 12:57:24 | 
| 34875320 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-11 18:23:44 | 
| 34879301 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-14 14:41:18 | 
| 34882396 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-08 12:57:35 | 
| 34884476 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-08 12:57:35 | 
| 36206502 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-19 12:17:42 | 
| 36921971 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-08-25 13:13:53 | 
| 42451175 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-07 12:07:40 | 
| 42451319 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-07 12:07:40 | 
| 42452368 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-12 10:33:26 | 
| 42454535 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-07 12:07:40 | 
| 42455262 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-07 12:07:40 | 
| 42979670 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-13 18:17:22 | 
| 43252074 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-13 18:17:29 | 
| 43256395 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-10-13 18:17:29 | 
| 46890036 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-11-09 13:31:14 | 
| 47989594 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-11-16 16:34:24 | 
| 47994151 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-11-16 16:34:24 | 
| 50667399 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-12-01 14:12:15 | 
| 53760743 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-12-15 17:14:10 | 
| 53777624 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-12-15 17:14:10 | 
| 53987172 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-12-16 10:05:18 | 
| 53996368 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2011-12-16 12:37:17 | 
| 58694386 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2012-01-19 13:14:17 | 
| 59783276 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2012-01-30 14:07:29 | 
| 60361824 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2012-01-30 14:08:40 | 
| 69371908 | www.ozon.ru/context/detail/id/5779455/?from=yandex_direct_soft_assassin_creed_2_bh | 2012-06-21 11:19:51 | 
+----------+------------------------------------------------------------------------------------+---------------------+

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

my $sql_cond = q/geo IS NOT NULL AND LENGTH(geo) > 0 AND geo NOT REGEXP "^[ 0-9\-]"/;

$log->out('Fetching pids to fix');
my $pids = get_one_column_sql(PPC_HEAVY, [q/SELECT pid FROM phrases WHERE/, $sql_cond]);
$log->out('Got ' . scalar(@$pids) . ' pids to fix:', $pids);

$log->out('Fixing geo');
my $affected_rows_cnt = do_sql(PPC, [q/UPDATE phrases SET geo = 0, statusBsSynced = "No" WHERE/, $sql_cond, 'AND', {pid => $pids}]);
$log->out("Fixed $affected_rows_cnt rows");

$log->out('FINISH');
