#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
[{
        type => 'sql',
        webstop => "0",
        db => "ppc",
        when => 'before',
        comment => "При выполнении нужно остановить только API (web_stop). Можно делать в любое время",
        time_estimate => "на devtest: ~ 12 sec",
        sql => "alter table users_api_options add column api_units_daily int(11) default NULL"
    },{
        type => 'script',
        when => 'after',
        time_estimate => '10 сек',
        comment => 'Заменяем множитель баллов на абсолютное кол-во баллов',
}]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use ScriptHelper;

$log->out("start");

my $res = get_one_column_sql(PPC, "select uid from users_api_options where api_units_factor > 1");
$log->out($res);

do_sql(PPC, ["update users_api_options set api_units_daily = api_units_factor * 32000", where => { uid => $res }]);

$log->out("end.");
