#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '60 секунд',
  comment => 'Удаляем баннеры для которых нет записи в phrases',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use ModerationQueue;
use Tag;
use Common qw(:subs);
use Yandex::DBTools;
use ScriptHelper;

use Data::Dumper;
use utf8;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    my $broken_banners = get_all_sql(PPC_HEAVY,
        "select b.cid, b.bid
         from banners b
           left join phrases ph using(bid)
         where ph.bid is null
           and b.LastChange > '2012-07-13 00:00:00'
           and b.LastChange < date_sub(NOW(), INTERVAL 1 HOUR)
        "
    );

    $log->die("Error: selected too much banners") if scalar(@$broken_banners) > 500;

    for my $row (@$broken_banners) {
        my ($cid, $bid) = ($row->{cid}, $row->{bid});
        my $bids = [$bid];

        # сохраянем на всякий случай удаляемые данные
        $log->out({deleted_bids => get_all_sql(PPC, "select * from bids where bid = ?", $bid)});
        $log->out({deleted_tag_banner => get_all_sql(PPC, "select * from tag_banner where bid = ?", $bid)});

        # все операции из Common::delete_banners(), но без проверок
        # удаляем объявления из базы
        del_banner_from_db($bids);

        # обновляем статус у кампании
        dbUpdateCampaignStatusModerate(PPC, $cid);

        # удаляем объявления с модерации, если они туда были отправлены
        del_banners_from_moderate($cid, $bids);

        # удаляем объявления из очереди на протукивание редиректа
        do_delete_from_table(PPC, 'redirect_check_queue', where => {object_id => $bids, object_type => 'banner'});

        # удаляем метки для объявлений
        Tag::delete_banner_tags($bids);

        $log->out({delete_banner => 1, cid => $cid, bid => $bid});
    }

    $log->out('finish');
}

# --------------------------------------------------------------------
main();
