#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'instructions',
  time_estimate => "10 минут",
  instructions => 'сначала обновить пакеты на одном из ppcback"ов, запустить скрипт, и сразу после скрипта обновлять пакеты на всех остальных серверах',
  comment => "Переводим все баннеры из Избранных в просто баннер с тегом 'избранные'"
}

=cut

use strict;
use warnings;
use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Tag;

use Yandex::DBTools;

use Data::Dumper;
use utf8;

$log->out("start");

my $favorite_text = "Избранное";
my $extra_favorite_text = "*Избранное";
# Достаем все баннеры с флагом statusFavorite = 'Yes'
my $data = get_all_sql(PPC,"SELECT bid, cid FROM banners WHERE statusFavorite = 'Yes'");
$log->out("Got ".(scalar @$data)." banners");

my $camp_banners = {};

# Создаем хеш из кампаний и принадлежавших им баннеров из избранных
foreach $b (@$data) {
  push @{$camp_banners->{$b->{cid}}}, $b->{bid};
}

# кампании, в которых уже есть метки "избранное";
my $camps_with_favorite_tag = {map{$_=>1} @{get_one_column_sql(PPC, "SELECT cid FROM tag_campaign_list WHERE tag_name = ?", $favorite_text) || []}};

while (my ($cid, $bids) = each(%$camp_banners)) {
    # Решаем какое имя использовать: Избранное или *Избранное (если такая метка уже есть, то используем со звездой.)
    my $tag_name = ($camps_with_favorite_tag->{$cid}) ? $extra_favorite_text : $favorite_text;
    #Добавляем новый тег в кампанию.
    my $new_tag_id = do_insert_into_table(PPC, 'tag_campaign_list', {cid => $cid, tag_name=>$tag_name}, ignore=>1);
    $log->out(sprintf("Added tag %s to campaign %d. New tag_id=%d", $tag_name, $cid, $new_tag_id));
    unless ($new_tag_id) {
        $log->out("Could not insert new tag ($tag_name) for campaign $cid");
        next;
    }
    #Добавляем к баннерам из папки избранных новый тег.
    my @for_insert = ();
    push @for_insert, [$_, $new_tag_id] foreach (@$bids);
    do_mass_insert_sql(PPC, 'INSERT INTO tag_banner (bid, tag_id) values %s', \@for_insert) if @for_insert;
    $log->out(sprintf("Set tag %s (%d) to %d banners: %s", $tag_name, $new_tag_id, scalar(@$bids), join ",",@$bids));
}
	
$log->out("finish");