#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'script',
  when => 'after',
  time_estimate => "12 часов",
  comment => "альтерим во всех ppcstat позаказные таблички из innodb в myisam"
},
{
        type => 'manual',
        when => 'after',
        text => 'по очереди сделать на всех ppcstat(после первых двух попросить zhur проверить):
lfw ppcstat -write
mysql -u root -S /var/run/mysqld.ppcstat/mysqld.sock -e "DROP TABLE IF EXISTS ppcstat.stat_phrases"
mysqldump -u root -S /var/run/mysqld.ppcstat/mysqld.sock ppcstat >/tmp/ppcstat.dump.sql
/etc/init.d/mysql.ppcstat stop
rm -rf /opt/mysql.ppcstat/ppcstat /opt/mysql.ppcstat/ib*
apt-get update && apt-get install yandex-direct-mysql-ppcstat
/etc/init.d/mysql.ppcstat start
mysql -u root -S /var/run/mysqld.ppcstat/mysqld.sock -e "create database ppcstat default character set utf8"
mysql -u root -S /var/run/mysqld.ppcstat/mysqld.sock ppcstat </tmp/ppcstat.dump.sql
lfw ppcstat +write
',
        time_estimate => '10 минут * 6 серверов',
},
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use DBStat;

use utf8;

$log->out('START');

my @ppcstat_hosts = sort DBStat->get_db_hosts("");
my $errors = 0;
for my $ppcstat_host ( @ppcstat_hosts ) {
    $log->out(" start process $ppcstat_host");
    my $dbh_stat = connect_db( $ppcstat_host );
    for my $table (@{get_all_sql(
                              $dbh_stat, "
                              SELECT table_schema, table_name
                                FROM INFORMATION_SCHEMA.TABLES
                               WHERE engine = 'InnoDB'
                                 and table_schema in ('ppcstat_data', 'ppcstat_phrases')
                               ")}
    ) {
        my $table_name = "$table->{table_schema}.$table->{table_name}";
        $log->out("  start alter $ppcstat_host: $table_name");
        my $res = eval {
            do_sql($dbh_stat, "ALTER TABLE $table_name ENGINE = 'MyISAM'");
            1;
        };
        if (!$res) {
            $log->out("   Error occured for $table_name: $@");
            $errors++;
        } else {
            $log->out("   $table_name altered");
        }
    }
}

if ($errors) {
    $log->die("FINISH, errors count: $errors");
} else {
    $log->out("SUCCESSFUL FINISH, errors count: $errors");
}
