#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '15 секунд',
  comment => q[
        Выставляет statusEasy=No пользователям со statusEasy=Yes и несколькими представителями.
        Обновит в том числе и "легкие" агенства (но только те, у кого несколько представителей)
  ]
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Data::Dumper;
use utf8;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    my $client_ids_to_update = get_one_column_sql(PPC, 
        "select ClientID from users 
        where ClientID in (
                select ClientID from users left join users_options using (uid) where statusEasy = 'Yes'
            )
            and ClientID > 0
        group by ClientID 
        having count(uid) > 1");

    $log->out("choose ClientIDs");
    $log->out($client_ids_to_update);

    my $cnt = do_sql(PPC, ["update users left join users_options using (uid) set statusEasy='No'", 
        where => {ClientID => $client_ids_to_update}]);
    $log->out("UIDS updates: $cnt");
    $log->out('finish');
}

# --------------------------------------------------------------------
main();
