#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '60 секунд',
  comment => 'актуализируем таймзоны',
}

=cut


use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Data::Dumper;

$log->out('start');

my %timezones = (
    # Asia/Novosibirsk => Asia/Omsk
    136 => 270,
    # Asia/Shanghai => Asia/Hong_Kong
    118 => 189,
    # Australia/Brisbane => Australia/Sydney
    92 => 91,
    43 => undef,
    89 => undef,
    95 => undef,
    144 => undef,
    177 => undef,
    220 => undef,
    246 => undef,
);

while (my ($from_tz, $to_tz) = each %timezones) {
    
    if ($to_tz) {
        my $cids = get_one_column_sql(PPC, "SELECT cid FROM campaigns WHERE timezone_id = ?", $from_tz) || [];
    
        $log->out(scalar(@$cids) .  " campaigns with tz " . $from_tz);
        while (my @ids = splice @$cids, 0, 700) {
            do_update_table(PPC, 'campaigns', {timezone_id => $to_tz, statusBsSynced => 'No'},
                                where => {cid => \@ids, timezone_id => $from_tz});
            $log->out(sprintf "%i campaigns moved from tz %i to tz %i \n cids: %s",
                        scalar(@ids), $from_tz, $to_tz, join ",", @ids)
        }
    }
    do_sql(PPCDICT, "DELETE FROM geo_timezones WHERE timezone_id = ?", $from_tz);
    $log->out("tz $from_tz deleted");
}

$log->out('finish');

