#!/usr/bin/perl

# https://jira.yandex-team.ru/browse/DIRECT-17568

=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '10 секунд',
    comment => 'Проставляем statusEasy = "No" на логинах с несколькими представителями',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Common qw(:subs);
use Yandex::DBTools;
use ScriptHelper;

use Data::Dumper;
use utf8;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    do_sql(PPC_HEAVY, "SET SESSION group_concat_max_len = 1000000");

    my $users = get_all_sql(PPC_HEAVY,
        "select u.ClientID
              , group_concat(IF(statusEasy = 'Yes', u.uid, NULL)) as uids
              , count(*) as cnt
              , sum(IF(statusEasy = 'Yes', 1, 0)) as easy_cnt
         from users u
           join users_options uo using(uid)
         where ClientID > 0
         group by u.ClientID
         having cnt > 1
            and easy_cnt > 0
        "
    );

    $log->out($users);

    for my $row (@$users) {
        my $uids = [split(/\s*,\s*/, $row->{uids})];
        next unless @$uids;

        my $upd_cnt = do_update_table(PPC, 'users_options', {statusEasy => "No"}, where => {uid => $uids});
        $log->out({upd_cnt => $upd_cnt, uids => $uids});
    }

    $log->out('finish');
}

# --------------------------------------------------------------------
main();
