#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "4 часа",
  comment => "на всех ppcstat* удаляем неиспользуемые order_stat_day_..."
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use DBStat;

use utf8;

$log->out('START');

my @ppcstat_hosts = sort DBStat->get_db_hosts("");
for my $ppcstat_host ( @ppcstat_hosts ) {
    $log->out(" start process $ppcstat_host");
    my $dbh_stat = connect_db( $ppcstat_host );
    for my $table (@{get_one_column_sql($dbh_stat, "SHOW TABLES FROM ppcstat_data LIKE 'order_stat_day_%'")||[]}) {
        $log->out("  start drop $ppcstat_host: $table");
        my $res = eval {
            do_sql($dbh_stat, "DROP TABLE ppcstat_data.$table");
            1;
        };
        if (!$res) {
            $log->out("   Error occured for $table: $@");
        }
    }
}

$log->out('FINISH');

