#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 минута',
  comment => 'Удаляем фразы, добавленные в другие кампании из-за бага в XLS-интерфейса, и отправляем на модерацию/делаем черновиком соответствующие баннеры',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Common;

use File::Slurp;
use JSON;

use utf8;
use open ':std' => ':utf8';

$log->out('START');

my @lines = read_file('deploy/20120816_delete-xls-bug-phrases.json.data');
for my $line(@lines) {
    my $bid_data = decode_json($line);
    my $bid = $bid_data->{bid};
    my $has_deleted_phrases = 0;
    for my $phrase(@{$bid_data->{phrases}}) {
        my %cond = (bid => $bid, id => $phrase->{id}, phrase => $phrase->{phrase}, cid__ne => $bid_data->{cid});
        my $old_phrase_data = get_one_line_sql(PPC, ['SELECT * from bids', WHERE => \%cond]);
        if ($old_phrase_data && %$old_phrase_data) {
            $log->out('Deleting from table bids: ', $old_phrase_data);
            do_delete_from_table(PPC, 'bids', where => \%cond);
            $has_deleted_phrases = 1;
        }
    }

    my %banner_cond = (bid => $bid);
    if ($has_deleted_phrases) {
        do_update_table(PPC, 'phrases', {statusBsSynced => 'No'}, where => \%banner_cond);
    }
    my $old_banner_statusModerate = get_one_field_sql(PPC, ['SELECT statusModerate FROM banners', WHERE => \%banner_cond]);
    next unless $old_banner_statusModerate;
    if ($bid_data->{was_on_moderation} && $old_banner_statusModerate eq 'New') {
        $log->out("Sending banner $bid to moderation (old statusModerate = $old_banner_statusModerate)");
        Common::send_banners_to_moderate(PPC, [$bid]);
    } elsif (!$bid_data->{was_on_moderation} && $old_banner_statusModerate ne 'New') {
        $log->out("Changing statusModerate for banner $bid to 'New' (old statusModerate = $old_banner_statusModerate)");
        do_update_table(PPC, 'banners', {statusModerate => 'New', statusBsSynced => 'No'}, where => \%banner_cond);
    }
}

$log->out('FINISH');
