#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 часа",
  comment => "унифицируем формат телефонов в визитках"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use VCards;

use Time::HiRes qw( sleep time );

use utf8;

$log->out('START');

$log->out('quering vcards');
my $vcards = get_all_sql(PPC, 'SELECT vcard_id, phone FROM vcards');
$log->out('got ' . scalar @$vcards . ' records');

$log->out('processing...');
my @time;
for my $item (@$vcards) {
    my $phone = $item->{phone};
    next if !$phone;

    my $new_phone = VCards::compile_phone( VCards::parse_phone($phone) );
    next if $new_phone eq $phone;

    $log->out("updating vcard #$item->{vcard_id}: '$phone' -> '$new_phone'");

    my $banners_to_resync = get_all_sql( PPC, [
            'SELECT cid, bid FROM banners b',
            WHERE => {
                vcard_id => $item->{vcard_id},
                'b.statusBsSynced' => "Yes",
            },
        ]);

    my $tr_start = time();
    do_in_transaction {
        do_update_table( PPC, 'vcards',
            { phone => $new_phone },
            where => $item
        );

        if ( @$banners_to_resync ) {
            do_mass_insert_sql( PPC,
                'INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s',
                [ map {[ $_->{cid}, $_->{bid} ]} @$banners_to_resync ],
            );
        }
    };

    sleep( (time()-$tr_start) * 3 );
}


$log->out('FINISH');

