#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 минуты",
  comment => q!
переотправляем контексты в БК через resync
перед запуском нужно
scp root@ppcdev:/tmp/cid_pid /tmp/cid_pid
!
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

open(F, "/tmp/cid_pid") || die $!;

my @rows = map {chomp;[split(/\s+/, $_), 100]} <F>;

for my $row (@rows) {
    $log->out($row);
}

do_mass_insert_sql(PPC, "INSERT INTO bs_resync_queue (cid, pid, priority) VALUES %s", \@rows);

$log->out('FINISH');

