#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '20 минут',
        comment => 'Включаем автоброкер во всех кампаниях, которые были загружены через xls после 2012-08-27 13:00'
    }

=cut

use strict;
use warnings;
use utf8;

use List::MoreUtils qw/uniq/;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Tools;
use Yandex::DBTools;
use ScriptHelper;
use Mcb;

$log->{tee} = is_beta();
$log->out('START');

my @cids = uniq @{get_one_column_sql(MONITOR, 'select cid from xls_checkin where logdate between "2012-08-27 13:00:00" and "2012-08-30 17:20"')};
$log->out((scalar @cids)." cids");
$log->out({ cids => \@cids });

# список пострадавших, для саппорта
my $affected = get_all_sql(PPC, ["select login, cid, name
    from campaigns c join users u on c.uid = u.uid ",
    where => { cid => \@cids },
    "order by login"
]);

$log->out('#####################');
$log->out( join "\n", map { sprintf "%s\t#%d (%s)", @$_{qw/login cid name/} } @$affected );
$log->out('#####################');

my $cnt_all = 0;
for my $cid (@cids) {
    my $cnt = do_update_table(PPC, 'bids', { AutoBroker => 'Yes', modtime__dont_quote => 'modtime' }, where => { cid => $cid });
    $log->out("$cnt bids updated for campaign $cid");
    $cnt_all += $cnt;

    my $bids = get_one_column_sql(PPC, "select bid from banners where cid = ? and statusArch = 'Yes'", $cid);
    if ($bids and @$bids) {
        $log->out({ "cid = $cid bids_arc banners" => $bids });
        my $cnt2 = do_update_table(PPC, 'bids_arc', { AutoBroker => 'Yes', modtime__dont_quote => 'modtime' }, where => { cid => $cid, bid => $bids });
        $log->out("$cnt2 bids_arc updated for campaign $cid");
        $cnt_all += $cnt2;
    }
}
$log->out("$cnt_all bids updated total");


$log->out('FINISH');
