#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 часа",
  comment => "разархивируем кампании, на которых ненулевой остаток средств"
}

=cut

use strict;
use warnings;

use Time::HiRes;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Common qw/:subs/;

use utf8;

$log->out('START');

for my $camp (@{get_all_sql(PPC, "SELECT cid, uid, sum, sum_spent, archived, statusShow
                                    FROM campaigns
                                   WHERE archived = 'Yes' and sum - sum_spent >= 0.009
                                ")}
) {
    $log->out($camp);
    if ($camp->{statusShow} eq 'Yes') {
        do_sql(PPC, "UPDATE campaigns SET statusShow = 'No', statusBsSynced = 'No' WHERE cid = ? and archived = 'Yes'",
               $camp->{cid});
    }
    my $t1 = Time::HiRes::time();
    my $res = unarc_camp(PPC, $camp->{uid}, $camp->{cid}, force => 1);
    $log->out("unarc result: $res");
    Time::HiRes::sleep(3 * (Time::HiRes::time() - $t1));
}

$log->out('FINISH');

