#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "8 часов",
  comment => "запустить без параметров. если реплики ppclog начнут тормозить, остановить скрипт и запустить с параметром --sleep-coef=10"
}

=cut

use strict;
use warnings;

use Time::HiRes;
use Yandex::TimeCommon;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

my $SLEEP_COEF = 3;
GetOptions(
    "sleep-coef=i" => \$SLEEP_COEF,
    );

$log->out('START');

my @dates = get_distinct_dates(20120701, yesterday());
if (@ARGV) {
    die "Usage: $0 date1, ..." if grep {!/^\d{8}$/} @ARGV;
    @dates = @ARGV;
} 

for my $date (@dates) {
    $log->out("start process $date");
    my $st = get_one_line_sql(PPCLOG, "SHOW TABLE STATUS LIKE 'logapi_$date'");
    if (!$st) {
        $log->out("no table status");
        next;
    }
    unless ($st->{Engine} eq 'MyISAM' and $st->{Row_format} eq 'Dynamic') {
        $log->out("Unsupported table format: $st->{Engine}/$st->{Row_format}");
        next;
    }
    for my $hour (0..23) {
        for my $min (0..59) {
            my $start_time = sprintf "$date%02d%02d00", $hour, $min;
            $log->out("Process $start_time");
            my $t1 = Time::HiRes::time();
            my $cnt = do_sql(PPCLOG, "UPDATE logapi_$date SET param = substr(param, 1, 1000) WHERE cmd = 'UpdatePrices' and char_length(param) > 1000 and logtime between ? and ? + interval 59 second", $start_time, $start_time);
            $log->out("updated $cnt rows");
            Time::HiRes::sleep($SLEEP_COEF*(Time::HiRes::time() - $t1));
        }
    }
}

$log->out('FINISH');

