#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "30 мин",
  comment => "чистим из bids_arc фразы, оставшиеся от удалённых кампаний"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;

use utf8;

$log->out('START');

my $cids = get_one_column_sql(PPC_HEAVY, "
    SELECT b.cid
      FROM bids_arc b
           LEFT JOIN campaigns c using(cid) 
     WHERE c.cid is null
     GROUP BY 1
") || [];

for my $cid (@$cids) {
    $log->out("delete bids_arc for cid = $cid");
    my $deleted = relaxed times => 3, sub {
        do_sql(PPC, "DELETE FROM bids_arc WHERE cid = ?", $cid);
    };
    $log->out("deleted $deleted bids_arc for cid=$cid");
}

$log->out('FINISH');

