#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 сек",
  comment => "удаляем данные по определённой РК по требованию юристов"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Primitives;
use RBAC2::Extended;
use RBACDirect;
use Tag;
use OrgDetails;
use ModerationQueue;

use utf8;

$log->out('START');

my $cid = 3177393;
my $uid = get_user_uid(PPC, $cid);

die "Incorrect camp status" if !get_one_field_sql(PPC, "
    SELECT 1 
      FROM campaigns
     WHERE statusShow = 'No'
       AND statusBsSynced = 'Yes'
       AND cid = ?
    ", $cid);


my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);

# удаляем все права
my $errcode = eval {rbac_delete_campaign($rbac, $cid, $uid);};
if ($@) {
    die "rbac die on delete campaign: $@";
} elsif ($errcode) {
    die "rbac error on delete campaign (cid: $cid, code: $errcode)";
}

my $dbh = get_dbh(PPC);

################
# кусок кода из del_camp_data
do_sql($dbh, "delete from user_campaigns_favorite where cid = ?", $cid);
# Удаляем метки;
Tag::delete_campaign_tags($cid);
my $bids = get_one_column_sql(PPC, "select bid from banners where cid = ?", $cid) || [];

# выбираем address_id только тех адресов которые встречаются только в удаляемой кампании и нигде больше
my $address_ids_data = get_all_sql(PPC, "select address_id
                                                      , count(distinct cid) as cids_cnt
                                                      , group_concat(DISTINCT cid) as cids
                                                 from vcards
                                                 where uid = ?
                                                   and address_id > 0
                                                 group by address_id
                                                 having cids_cnt = 1
                                                ", $uid);
my $address_ids = [map {$_->{address_id}} grep {$_->{cids} == $cid} @$address_ids_data];

do_sql($dbh, qq!REPLACE INTO deleted_banners ( bid, deleteTime ) SELECT bid, now() FROM banners WHERE cid=?!, $cid);
do_sql($dbh, qq!DELETE FROM banners WHERE cid = ?!, $cid);
do_sql($dbh, qq!DELETE FROM vcards WHERE cid = ?!, $cid);
do_delete_from_table(PPC, 'addresses', where => {aid => $address_ids}) if @$address_ids;
do_delete_from_table(PPC, 'phrases', where => {bid => $bids}) if @$bids;
do_sql($dbh, qq!DELETE FROM bids WHERE cid = ?!, $cid);
do_sql($dbh, qq!DELETE FROM bids_arc WHERE cid = ?!, $cid);
do_sql($dbh, qq!DELETE FROM mediaplan_banners WHERE cid = ?!, $cid);
do_sql($dbh, qq!DELETE FROM mediaplan_bids WHERE cid = ?!, $cid);        
do_delete_from_table(PPC, 'redirect_check_queue', where => {object_id => $bids, object_type => 'banner'}) if @$bids;
do_delete_from_table(PPC, 'banner_images', where => { bid => $bids }) if @$bids;
do_delete_from_table(PPC, 'autobudget_forecast', where => {cid => $cid});

del_banners_from_moderate($cid);
clean_org_details(uid => $uid);



do_sql(PPC, "UPDATE campaigns SET statusEmpty = 'Yes' WHERE cid = ?", $cid);

$log->out('FINISH');

