#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "15 минут",
  comment => "Исправляем неправильную фиксацию стоп-слов (+!слово -> !слово)"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Tools;

use utf8;

$log->{tee} = is_beta();
$log->out('START');

my ($min_id, $max_id) = get_one_line_array_sql(PPC, "select min(id), max(id) from bids");
my $chunk = 15_000_000;
my %update;
while ($min_id < $max_id) {
    $log->out("id $min_id");
    my $phrases = get_all_sql(PPC_HEAVY, [
        "select bi.id, bi.phrase, p.pid from bids bi join phrases p on p.bid = bi.bid", where => {
            phrase__like => '%+!%',
            id__between => [$min_id, $min_id+$chunk],
        },
    ]) || [];
    $log->out((scalar @$phrases)." phrases");

    for my $p (@$phrases) {
        $p->{old_phrase} = $p->{phrase};
        $p->{phrase} =~ s/\+!/!/g;
        $log->out($p);
        $update{$p->{id}} = $p;
    }
    $min_id += $chunk;
    if (keys %update > 1000) {
        _update_chunk(\%update);
    }
}
if (keys %update) {
    _update_chunk(\%update);
}

$log->out('FINISH');

sub _update_chunk
{
    my ($update) = @_;
    my $case_id_phrase = sql_case(PPC, 'id', { map { $_ => $$update{$_}{phrase} } keys %$update }, default__dont_quote => 'phrase');
    my $case_id_old = sql_case(PPC, 'id', { map { $_ => $$update{$_}{old_phrase} } keys %$update }, default__dont_quote => 'phrase');
    do_sql(PPC, ["
        update bids set phrase = $case_id_phrase, statusBsSynced = 'No'
        where ", { id => [ keys %$update ] }, "and phrase = $case_id_old
    "]);
    do_update_table(PPC, "phrases", { statusBsSynced => 'No' }, where => { pid => [ map { $_->{pid} } values %$update ] });
    $update = {};
}
