#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => "ppc",
  when => 'before',
  time_estimate => "1 сек.",
  sql => [qq!
CREATE TABLE bs_auction_stat (
  pid int(10) NOT NULL DEFAULT '0',
  PhraseID int(10) NOT NULL DEFAULT '0',
  shows int(10) NOT NULL DEFAULT '0',
  clicks int(10) NOT NULL DEFAULT '0',
  rank int(10) unsigned NOT NULL DEFAULT '0',
  stattime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  pshows int(10) unsigned NOT NULL,
  pclicks int(10) unsigned NOT NULL,
  PRIMARY KEY (pid,PhraseID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
  !,
qq!
CREATE TABLE bs_auction_stat_context (
  pid int(10) NOT NULL DEFAULT '0',
  PhraseID int(10) NOT NULL DEFAULT '0',
  rank int(10) unsigned NOT NULL DEFAULT '0',
  stattime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (pid,PhraseID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
!,
qq!
CREATE TABLE bs_auction_stat_off (
  pid int(10) NOT NULL DEFAULT '0',
  PhraseID int(10) NOT NULL DEFAULT '0',
  shows int(10) NOT NULL DEFAULT '0',
  clicks int(10) NOT NULL DEFAULT '0',
  rank int(10) unsigned NOT NULL DEFAULT '0',
  stattime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  pshows int(10) unsigned NOT NULL,
  pclicks int(10) unsigned NOT NULL,
  PRIMARY KEY (pid,PhraseID)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
!,
]
},
{
  type => 'sql',
  webstop => 0,
  db => 'ppcdict',
  when => 'before',
  time_estimate => "1 сек.",
  sql => q!insert into ppc_properties (name, value) 
    select "last_bs_auction_stat_reqid", value 
    from ppc_properties where name = "last_priorities_reqid"!,
},
{
  type => 'script',
  when => 'after',
  time_estimate => "несколько часов, до 10-12, а может и больше",
  comment => q!прогресс можно отслеживать по логу скрипта и по размерам таблиц: 
show table status like "bs_auction_stat%"\G
в результате количество строк должно получиться примерно как в соответствующих таблицах priorities:
show table status like "priorities%"\G
Если будут тормозить реплики, можно запустить с большими паузами (параметр sleep -- секунды): 
/var/www/pcc.yandex.ru/deploy/20121031_priorities_to_bs_auction_stat.pl --sleep 5
!
},
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

my @tasks = (
    {
        from => 'priorities_context',
        to => 'bs_auction_stat_context',
        chunk_size => 2_000_000,
        stat_fields => [qw/rank stattime/],
    },
    {
        from => 'priorities',
        to => 'bs_auction_stat',
        chunk_size => 500_000,
        stat_fields => [qw/shows clicks rank stattime pshows pclicks/],
    },
    {
        from => 'priorities_off',
        to => 'bs_auction_stat_off',
        chunk_size => 2_000_000,
        stat_fields => [qw/shows clicks rank stattime pshows pclicks/],
    },
);

my $SLEEP = 1;

GetOptions(
    "sleep=i" => \$SLEEP,
);

# do_insert_select_sql без ограничений не проходит, mysql падает с OOM, поэтому будем разбивать запросы на кусочки
my $max_PriorityID = get_one_field_sql(PPC, "select max(PriorityID) from phrases");
for my $t (@tasks) {
    $log->out("from $t->{from} to $t->{to} - start");
    my $chunk_size = $t->{chunk_size} || 200_000;
    my $chunks = int($max_PriorityID/$chunk_size) + 1;
    $log->out("max(PriorityID): $max_PriorityID, chunk_size: $chunk_size, chunks: $chunks");
    my $stat_fields_str = join ", ", @{$t->{stat_fields}};
    for my $n (0 .. $chunks - 1){
        my $start = $chunk_size * $n;
        my $end = $start + $chunk_size - 1;
        my $cnt = do_insert_select_sql(PPC, 
            "INSERT IGNORE INTO $t->{to} 
            (pid, PhraseID, $stat_fields_str) 
            VALUES %s", 
            "SELECT ph.pid, PhraseID, $stat_fields_str 
            FROM $t->{from} p join phrases ph on ph.PriorityID = p.PriorityID
            WHERE p.PriorityID > 0
                and p.PriorityID between $start and $end
            ", sleep => $SLEEP, max_row_for_select => 20_000, max_row_for_insert => 20_000);
        $log->out("progress: PriorityID $start .. $end, moved $cnt rows from $t->{from} to $t->{to}");
    }
    $log->out("from $t->{from} to $t->{to} - done");
}

$log->out('FINISH');

