#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 минуты",
  comment => "удалить статистику для заказов из тяжелых pdf отчётов
  
      после выполнения скрипта нужно остановить скрипт формирования отчетов, 
      что бы он начал собирать статистику заново
      
      /var/www/ppc.yandex.ru/protected/ppcPdfReports.pl --stop --queue heavy
  "
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use DBStat;

use utf8;

$log->out('start');

my $reports = get_one_column_sql(PPC, 
    "select cids from pdf_reports where phrases_count >= 60000 and status <> 'ready' AND create_time > '2012-11-01'");
my @cids = map {split ",", $_} @$reports;

$log->out("reports => " . scalar @$reports);
$log->out("campaigns => " . scalar @cids);
    
my $orders = get_one_column_sql(PPC_HEAVY, ["SELECT OrderID FROM campaigns", WHERE => {
    OrderID__gt => 0, cid => \@cids
}]);

$log->out("orders => " . scalar @$orders);    
 
foreach my $id (@$orders) {
    DBStat->new(OrderID => $id)->drop_order_tables($id);
}

$log->out('finish');