#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '2-5 дней',
        comment => q[
            Добавляем поле ContextType в таблицы со статистикой.
            Параметры запуска - номера инстанса базы на которых будет применена миграция.

            Как запускать:
            deploy/20121112_add_ContextType_column_to_ppcstatdata.pl 1 2 3 4 5 6 7 8
        ],
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use Yandex::Retry;
use ScriptHelper;

# --------------------------------------------------------------------
sub main {
    for my $shard_num (@ARGV) {
        $log->out("ppcstat:$shard_num start");
        my $dbh = connect_db(get_db_config("ppcstat:$shard_num"));
        add_column($dbh, $shard_num);
        $log->out("ppcstat:$shard_num finish");
    }
}

# --------------------------------------------------------------------
sub add_column {
    my ($dbh, $instance) = @_;

    my $tables = get_one_column_sql($dbh, q[SHOW TABLES IN ppcstat_data LIKE 'order_stat_%']) || [];
    my ($cnt, $total) = (0, scalar @$tables);

    $dbh->{HandleError} = sub {return 1};

    for my $table_name (@$tables) {

        my ($oid) = $table_name =~ /^order_stat_(\d+)$/;
        next unless $oid;

        for my $table (qw/stat stat_small/) {
            relaxed times => 1, sub {
                eval {
                    if ($table eq 'stat') {
                        do_sql($dbh, qq[ALTER TABLE ppcstat_data.order_${table}_$oid
                                        ADD COLUMN ContextType tinyint unsigned NOT NULL DEFAULT 1
                                        AFTER PhraseID
                                        , DROP primary key
                                        , ADD primary key (hitDate, BannerID, PhraseID, ContextType, region, PageID, TypeID)
                                       ]);
                    } elsif ($table eq 'stat_small') {
                        do_sql($dbh, qq[ALTER TABLE ppcstat_data.order_${table}_$oid
                                        ADD COLUMN ContextType tinyint unsigned NOT NULL DEFAULT 1
                                        AFTER PhraseID
                                        , DROP primary key
                                        , ADD primary key (hitDate, BannerID, PhraseID, ContextType, TargetType)
                                       ]);
                    }
                };
                $log->out("ppcstat:$instance order_${table}_$oid: " . $@) if $@;
            };
        }
        $log->out("ppcstat:$instance order_stat $cnt/$total tables done") unless ++$cnt % 1000;
    }
}

# --------------------------------------------------------------------
main();
