#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '2-3 дня',
        comment => q[ 16 октября 2012 года из БК пришло очень много битой агрегированной статистики, апдейтим статистику на нашей стороне за этот день ],
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use DateTime;
use Yandex::Retry;
use ScriptHelper;
use BSStatImport;

$log->out("start");
my $PACKET = 5;
my $date = DateTime->new( year => 2012, month => 10, day => 16)->ymd('');

$log->out("getting orders from direct_stat.bs_order_target_stat...");
my $OrderIDs = get_one_column_sql(PPCORDSTAT, "select distinct(OrderID) from direct_stat.bs_order_target_stat where stat_date = '2012-10-16' order by OrderID");
$log->out(sprintf("%s orders got", scalar(@$OrderIDs)));

while(my @chunk = splice(@$OrderIDs, 0, 10000)){
    my $statistics = [];
    $log->out("get some statistics from BS");
    for my $oid (@chunk){
        my $st = BSStatImport->new( type => 'period', params => { orderid => $oid, start => $date, stop => $date } );
        my $error = $st->get();
        if($error){
            $log->out(sprintf("when asked %s, then following error was occured: %s", $st->get_url, $error));
            next;
        } else {
            push(@$statistics, @{$st->as_arrayref( date => 1, sum => 5 )});
        }
    }
    $log->out(sprintf("got %s good rows", scalar(@$statistics)));

    $log->out("updating...");
    do_mass_insert_sql(PPCORDSTAT, qq{insert into direct_stat.bs_order_target_stat (OrderID, stat_date, target_type, shows, clicks, sum)
            values %s ON DUPLICATE KEY UPDATE shows=values(shows), clicks=values(clicks), sum=values(sum)}, $statistics);
    $log->out("data was updated");
}
$log->out("stop");
