#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '0',
        comment => q[ у клиентов баяна, которые приобрели пакет кликов, в интерфейсе отображается не кол-во открученных показов, а кол-во открученных пакетов ],
    }

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use Data::Dumper;

my @camps = qw(5504269 5505842 5578535);
my $camps = get_hashes_hash_sql(PPC, ["select cid, ProductID, sum_spent from campaigns", where => { cid__in => \@camps}]);

my @products = map {$camps->{$_}->{ProductID} } keys %$camps;
my $products = get_hashes_hash_sql(PPC, ["select ProductID, Rate, Price, packet_size from products", where => { ProductID__in => \@products}]);


for my $cid (keys %$camps){
    my $sum_spent = $camps->{$cid}->{sum_spent};
    my $ProductID = $camps->{$cid}->{ProductID};
    my $Rate = $products->{$ProductID}->{Rate};
    my $Price = $products->{$ProductID}->{Price};
    my $packet_size = $products->{$ProductID}->{packet_size};
    my $sum_spent_units = $sum_spent * $Rate * $packet_size / $Price;

    do_sql(PPC, "update campaigns set sum_spent_units = $sum_spent_units where cid = $cid"); 
}
