#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд',
  comment => 'Исправляем в баяновских кампаниях пустую валюту на YND_FIXED',
}

=cut

=head2 DESCRIPTION

    m pr:ppc:heavy 'select type,count(*),max(create_time) from campaigns inner join camp_options using (cid) where currency = "" group by type'
    +------+----------+---------------------+
    | type | count(*) | max(create_time)    |
    +------+----------+---------------------+
    | mcb  |     3179 | 2012-10-09 17:32:07 |
    +------+----------+---------------------+

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::ListUtils qw/chunks/;

use utf8;

$log->out('START');

my $cids = get_one_column_sql(PPC_HEAVY, 'SELECT cid FROM campaigns WHERE currency = ""') || [];
$log->out('Got ' . scalar(@$cids) . ' cids to set currency');
for my $cids_chunk (chunks($cids, 500)) {
    $log->out('Updating cids chunk with ' . scalar(@$cids_chunk) . ' records:', $cids_chunk);
    do_update_table(PPC, 'campaigns', {currency => 'YND_FIXED'}, where => {currency => '', cid => $cids_chunk});
}

$log->out('FINISH');
