#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
    {
        type => 'sql',
        webstop => "1",
        db => "ppc",
        when => 'before',
        time_estimate => "2 часа",
        sql => "ALTER TABLE banners ADD COLUMN yacontextCategories text",
        comment => "
        
            !АЛЬТЕР на продакшен базах данных уже применен, необходимо выполнить только 
            скрипт по переносу данных.
        
        	на ТС нужно сделать до начала тестирования релиза
        	
			в продакшене делать на следующий день после релиза,
			утром сделать на максимальном количестве реплик,
			вечером переключиться, доделать на остальных серверах.
        "
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => '4.5 часа',
        comment => q[
            Переносим категории баннеров с условия показа на баннеры
            
            можно запускать с коэффициентом для вычисления паузы между итерациями
            (что бы реплики не отставали)
        
            20121130_fill_banners_yacontextCategories.pl --sleep-coeff=1
            если реплики отстают, можно увеличить --sleep-coeff
        ],
    }
]

=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Getopt::Long;
use Yandex::Retry;
use Settings;
use Yandex::DBTools;
use ScriptHelper;
    
use constant PIDS_PER_ITERATION => 10000;

my $sleep_coeff = 1;
GetOptions(
    'sleep-coeff=i' => \$sleep_coeff,
);

$log->out('start');
while (my $banners = get_next_banners()) {
    relaxed times => $sleep_coeff, sub {
        do_update_table(PPC, 'banners', {
            LastChange__dont_quote => 'LastChange',
            yacontextCategories__dont_quote => sql_case(PPC, bid => $banners)
        }, where => {bid => [keys %$banners]});
    }
}
$log->out('finish'); 

{
my ($max_pid, $offset);
sub get_next_banners {
    
    $max_pid = get_one_field_sql(PPC, 'SELECT MAX(pid) FROM phrases') unless defined $max_pid;
    $offset = 0 unless defined $offset;
    
    my $banners = [];
    while (!@$banners && $offset <= $max_pid) {
        $banners = get_all_sql(PPC,
                    "SELECT bid, yacontextCategories FROM phrases WHERE pid BETWEEN ? AND ? AND IFNULL(yacontextCategories, '') != ''",
                    $offset, $offset + PIDS_PER_ITERATION);
        $offset += PIDS_PER_ITERATION + 1;
    }
    
    $log->out(sprintf "got %d banners; processed %d/%d", scalar(@$banners), $offset, $max_pid); 
    
    return @$banners ? {map {($_->{bid} => $_->{yacontextCategories})} @$banners} : undef;
}
}
