#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "11 часов",
  comment => "Скрипт пересчитывает возрастные метки на баннерах у пользователей на которых есть хотя бы один баннер с меткой plus18"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Catalogia;
use ScriptHelper;
use JSON::Syck;

use List::MoreUtils qw/uniq/;

use Data::Dumper;

binmode(STDOUT, ':utf8');

$Yandex::Catalogia::CATALOGIA_URL = ['http://catalogia-mod.yandex.ru/cgi-bin/get_categs.pl']; 

use utf8;

my $chunk_size = 20000; #100_000;

$log->out('START');

my %users;

my $total_bids = 0;

my ($min_uid, $max_uid) = get_one_line_array_sql(PPC_HEAVY,'select min(uid), max(uid) from  banners');

#Чтобы  в случае падения начать не с начала, а с заданного уида, передаем его
if ($ARGV[0]) {
    $max_uid = $ARGV[0];
}

while ($max_uid > $min_uid) {
    $log->out("$max_uid - ".($max_uid - $chunk_size));
    my $uids = get_one_column_sql(PPC_HEAVY, ["select uid from banners",
                                               where => { flags__rlike => '(^|,)plus18(,|$)', 
                                                          uid__ge => ($max_uid - $chunk_size), uid__lt => $max_uid } ] ) || [];

    $log->out((scalar @$uids)." uids");
    
    foreach my $row (@$uids) {
        next if exists $users{$row};
        
        check_campaign($row);
        
        $log->out("banners count: $total_bids");
        $users{$row} ||= 0;
    }

    $max_uid -= $chunk_size;
}

check_campaign();

$log->out('FINISH');
$log->out('UIDS');
$log->out(join("\n", grep { $users{ $_ } > 0 }  keys %users));
$log->out('END OF UIDS');

{
my @pending_campaign;

sub check_campaign
{
    my ($uid) = @_;
    my $banners = [];

    if ($uid) {
        $banners = get_all_sql(PPC_HEAVY, ["select bid, uid, cid, body, title, flags from banners", where => {uid => $uid }]);
    }

    push @pending_campaign, @$banners;

    if (@pending_campaign > 1000 || !$uid) {
        
        while (my @chunk = splice @pending_campaign, 0, 1000) {
            $total_bids += scalar @chunk;
            process_banners(\@chunk);
            last if @pending_campaign < 1000 && $uid;
        }

        @pending_campaign = ();
    }
}
}

sub process_banners {
    my ($banners) = @_;

    my $flags = get_banners_flags($banners);
    
    my $SET_CONDITION = "";
    
    my @bids;
    my @magic_queue;

    my $dbh = get_dbh(PPC);

    for (my $i = 0; $i < @{$banners || [] }; ++$i) {
        my $banner_flags_hash = get_banner_flags_as_hash($banners->[$i]{flags}, 1);
        delete $banner_flags_hash->{age};
        
        my $changed = 0;

        if ($flags->[$i]) {
            $changed = 1 if !$banner_flags_hash->{plus18};
            $banner_flags_hash->{plus18} = 1;
        }
        else {
            $changed = 2 if $banner_flags_hash->{plus18};
            delete $banner_flags_hash->{plus18};
        }
        
        if ($banner_flags_hash->{plus18}) {
            $users{ $banners->[$i]{uid} } = 1;
        }

        next unless $changed;

        push @bids, $banners->[$i]{bid};
        push @magic_queue, _flags_magic_queue_format($banners->[$i]{bid}, $banners->[$i]{cid}, $banner_flags_hash);

        $SET_CONDITION .= " WHEN ".$dbh->quote($banners->[$i]{bid})." THEN ".$dbh->quote( serialize_banner_flags_hash($banner_flags_hash) );
    }
    
    if (@bids) {
        my $SQL = ["update banners set statusBsSynced = 'No', 
                                       lastchange = lastchange,
                                       flags = CASE bid ".$SET_CONDITION." ELSE flags END ", 
                    where => { bid => \@bids } ];

        do_sql(PPC, $SQL);
        do_mass_insert_sql(PPC, "insert into moderation_cmd_queue (cmd, cid, data) values %s", \@magic_queue);
    }

}

sub get_banners_flags
{
    my $banners = shift;

    my @req;
    

    foreach my $banner (@$banners) {
        push @req, {
            body => $banner->{body},
            title => $banner->{title},
 #          phrases => join(" ", map {clear_minus_phrases($_->{phrase})} grep {ref($_)} @{$banner->{phrases}{data}->{phrases} || []}),
            phrases => "",
        };
    }
    
    my $st = time();
    my $cat_res = Yandex::Catalogia::banner_classify(\@req, {timeout => 60});

    my @result;
    
    if (scalar @{$cat_res || []}) {
        for (my $i = 0; $i < scalar @$banners; $i++) {
            $result[$i] = scalar grep { $_ eq 'plus18' } @{ $cat_res->[$i]->{flag} || [] };
        }
    }

    return \@result;
}

sub _flags_magic_queue_format
{
    my ($bid, $cid, $banner_flags_hash) = @_;

    return ['updateBannerFlags',
             $cid,
             JSON::Syck::Dump(
                                {
                                  bid => $bid,
                                  flags => convert_flags_to_moderation_format($banner_flags_hash),
                                }
                             )
           ];
}

our %AD_WARNINGS = (
    'abortion' => {},
    'medicine' => {},
    'alcohol' =>  {},
    'tobacco' =>  {},
    'age'    =>   {variants => [qw/18 16 12 6 0/], is_common_warn => 1},
);

=head2 get_banner_flags_as_hash

    Функция десериализует поле флагов баннера в хеш

=cut

sub get_banner_flags_as_hash
{
    my ($flags, $all_flags) = @_;
    my %result;

    my @kv = split(/,/, $flags || '');
    
    foreach my $part (@kv) {
        my ($warn_name, $value) = map { lc($_) } split(/:/, $part, 2);
        
        next if !$all_flags && !defined $AD_WARNINGS{$warn_name};

        if (defined $AD_WARNINGS{$warn_name}{variants}) {
            next if !defined $value || !grep { $value eq $_ } @{ $AD_WARNINGS{$warn_name}{variants} };
        }

        $value = 1 unless defined $value;
        $result{$warn_name} = $value;
    }
    
    return \%result;
}

=head2 serialize_banner_flags_hash

Сериализует хеш с флагами для сохранения в базе Директа.

=cut

sub serialize_banner_flags_hash
{
    my ($flags) = @_;
    my @accumulator;

    foreach my $flag (sort keys %$flags) {
        if (defined $AD_WARNINGS{$flag}{variants}) {
            push @accumulator, $flag.":".$flags->{$flag};
        }
        else {
            push @accumulator, $flag;
        }
    }

    return join(",", @accumulator);
}


=head2 convert_flags_to_moderation_format

Конвертирует хеш с флагами в формате Директа в хеш понятный модерации.

=cut

sub convert_flags_to_moderation_format
{
    my ($flags) = @_;
    
    my %result;

    foreach my $flag_name (sort keys %$flags) {
        if ($flag_name eq 'age') {
            my $value = $flags->{$flag_name};
            $result{$flag_name} = "age".$flags->{$flag_name};
        }
        else {
            $result{$flag_name} =  $flags->{$flag_name};
        }
    }
    
    return \%result;
}

