#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr

[{
  type => 'sql',
  webstop => 0,
  when => 'before',
  db => 'ppc',
  time_estimate => '1 секунду',
  comment => '',
  sql => qq/CREATE TABLE `pre_moderate_banners` (
     `bid` int(10) NOT NULL DEFAULT '0',
     PRIMARY KEY (`bid`)
   ) ENGINE=InnoDB DEFAULT CHARSET=utf8/  
}, {
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд',
  comment => 'Копируем данные из старой таблицы в новую',
}]

=cut

=head2 DESCRIPTION

    Раньше флаг о необходимости премодерации кампании хранился на уровне кампании (cid)
    Это удобно, когда кампания отправляется в экспорте целиком. 
    Но если кампания отправляется в экспорте на модерацию частями - то может проявляться ошибка из-за преждевременного удаления флага.
    
    Скрипт делает миграцию флага с уровня кампании на уровень объявления.

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

my $bids = get_one_column_sql(PPC, "select bid from banners b join pre_moderate prm on b.cid=prm.cid") || [];
do_mass_insert_sql(PPC, "insert ignore into pre_moderate_banners(`bid`) values %s", [map {[$_]} @$bids], {sleep => 1, max_row_for_insert => 10_000}) if $bids && @$bids;

$log->out({bid => $bids, bids_cnt => scalar(@$bids)});

$log->out('FINISH');
