#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage 
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "15 минут",
  comment => "Удаляем из очереди на простукивание домены, которые не требуют проверки"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Tools;
use URLDomain;
use ScriptHelper;
use Yandex::MirrorsTools::Hostings qw/strip_domain strip_www/;

use utf8;

$log->out('START');

my ($step) = (5_000);
my ($max, $min) = get_one_line_array_sql(PPC, "select max(id), min(id) from redirect_check_queue");

my $curr = $max;
my ($cnt, $count_cleared_banners) = (0,0);
my %CACHE = ();

while ($curr > $min) {
    my (@delete, @delete_bids);

    my $res = get_all_sql(PPC, "select id, object_id, href from redirect_check_queue rcq left join banners b on b.bid=rcq.object_id where id between ? and ?", ($curr - $step), $curr);

    foreach my $r (@$res) {
        my $domain = get_Host($r->{href}) || '';

        my $known_redirect = defined $CACHE{$domain} ? $CACHE{$domain} : is_known_redirect($domain);
        $CACHE{$domain} ||= $known_redirect;

        # если домен не счетчик, и не хостинговый - то удаляем из очереди
        unless ($known_redirect || strip_domain($r->{href}) ne strip_www($domain)) {
            push @delete, $r->{id};
            push @delete_bids, $r->{object_id};

            $count_cleared_banners += 1;
        }
    }

    if (scalar @delete) {
        $log->out(\@delete_bids);
        do_delete_from_table(PPC, 'redirect_check_queue', where => {id => \@delete});
    }

    $curr -= $step;
}

$log->out({total_deleted => $count_cleared_banners});;
$log->out('FINISH');

