#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "30 сек.",
  comment => qq{
        Добавляем новые номера в рамках эксперимента PayPerCall.
        Если указан логин, то применяем телефон для всех кампаний этого клиента.
        Совпало, что у всех номеров телефона код-города 495.
    }
}

=cut

use strict;
use warnings;

use Data::Dumper;
use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$Data::Dumper::Indent = 0;
$Data::Dumper::Terse = 1;

################ start ################
$log->out('START');

my $city_code = 495;
my $data = newdata();

for my $row (@$data){
    if (exists $row->{login}) {
        my $login = $row->{login};
        my $ClientID = get_one_field_sql(PPC, "select ClientID from users where login = ?", $login);
        $row->{cids} = get_one_column_sql(PPC, "select cid from campaigns where statusEmpty = 'No' and ClientID = ?", $ClientID);
    }
}

for my $row (@$data){
    # add phones to database
    my @new_rows = map { [$_, 495, $row->{phone}] } @{$row->{cids}};
    do_mass_insert_sql(PPC, 'insert into pay_per_call_phones (cid, city_code, number) values %s', \@new_rows);
    $log->out("cid city_code number: " .  Dumper(\@new_rows));

    # drop statusBsSynced
    my $bids = get_one_column_sql(PPC, ['select bid from banners', where => {cid__in => $row->{cids}}]);
    do_update_table(PPC, 'banners', { statusBsSynced => 'No' }, where => {bid__in => $bids});
    $log->out("bids: " . Dumper($bids));
}

$log->out('FINISH');
################ end ################

sub newdata
{
    return [
        {
            phone => '363-43-33',
            cids => [3331843]
        },
        {
            phone => '788-83-88',
            login => 'shinserviceru'
        },
        {
            phone => '649-41-27',
            login => 'mag-transport'
        },
        {
            phone => '660-18-26',
            cids => [251662, 2424987, 2425004]
        },
        {
            phone => '669-77-79',
            cids => [   1214656, 1459869, 1547887, 1644523, 1666429, 1701992, 1701999,
                        1741894, 1797000, 1797135, 1818082, 1821516, 2264878, 2266495,
                        2516236, 2810312, 2839909, 3283777, 3291099, 3323306, 3349959,
                        3593316, 3992475, 4023682, 4230666, 4230704, 4230709, 4762615]
        },
        {
            phone => '999-66-55',
            login => 'autoranger1'
        },
        {
            phone => '380-00-55',
            cids => [   619922, 761933, 731581, 3249460, 1025176, 2871241, 731162, 1706996,
                        731406, 4507506, 3283062, 3283034, 3283042, 1883791, 3283079, 4507498, 4507485, 4507515]
        },
        {
            phone => '651-64-21',
            cids => [4952524, 4952526]

        },
        {
            phone => '961-22-22',
            login => 'webpizza'

        },
        {
            phone => '774-28-77',
            login => 'masterstolizi'
        },
        {
            phone => '797-21-21',
            cids => [3123007]
        },
        {
            phone => '500-72-09',
            cids => [4176044, 4602067, 4683976, 3293280, 4146545, 4139884]
        },
        {
            phone => '411-60-05',
            cids => [2095476, 5580692]
        },
        {
            phone => '662-56-78',
            cids => [4952656]
        },
        {
            phone => '991-69-91',
            cids => [1874893]
        },
        {
            phone => '727-28-28',
            login => 'taximillennium'
        },
        {
            phone => '666-20-00',
            cids => [1706788, 5483440, 5483441, 5602717, 5656831]
        },
        {
            phone => '411-94-60',
            cids => [4176830]
        },
    ]
}
