#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "24 часа",
  comment => "Скрипт пересчитывает возрастные метки на баннерах у всех пользователей, 
              для ускорения исключили пользователей у которых уже есть такой флаг.
              В случае падения скрипта он напишет в лог Catalogia failed.
              Чтобы перезапустить скрипт надо найти в логе поелдний max_cid и запустить скрипт с этим параметром."
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::Catalogia;
use ScriptHelper;
use JSON::Syck;

use List::MoreUtils qw/uniq/;

use Data::Dumper;

binmode(STDOUT, ':utf8');

$Yandex::Catalogia::CATALOGIA_URL = ['http://catalogia-mod.yandex.ru/cgi-bin/get_categs.pl', 'http://catalogia-mod.yandex.ru/cgi-bin/get_categs.pl'];

use utf8;

my $chunk_size = 1000;

$log->out('START');

my %campaigns;

my $total_bids = 0;

my ($min_cid, $max_cid) = get_one_line_array_sql(PPC_HEAVY,'select min(cid), max(cid) from banners');

#Чтобы  в случае падения начать не с начала, а с заданного уида, передаем его
if ($ARGV[0]) {
    $max_cid = $ARGV[0];
}

while ($max_cid > $min_cid) {
    $log->out("$max_cid - ".($max_cid - $chunk_size));

    my $cids = get_all_sql(PPC_HEAVY, ["select cid, uid from banners",
                                               where => { cid__ge => ($max_cid - $chunk_size), 
                                                          cid__lt => $max_cid }, "group by cid" ] ) || [];

    $log->out((scalar @$cids)." cids");
    $log->out("max-cid=$max_cid");

    foreach my $row (@$cids) {
        next if exists $campaigns{$row->{cid}};

        check_campaign($row->{cid});
        
        $log->out("banners count: $total_bids");
        $campaigns{$row->{cid}} ||= 0;
    }

    $max_cid -= $chunk_size;
}

check_campaign();

$log->out('FINISH');

{
my @pending_campaign;

sub check_campaign
{
    my ($cid) = @_;
    my $banners = [];

    if ($cid) {
        $banners = get_all_sql(PPC_HEAVY, ["select bid, cid, body, title, flags from banners", where => {cid => $cid }]);
    }

    push @pending_campaign, @$banners;

    if (@pending_campaign > 1000 || !$cid) {

        while (my @chunk = splice @pending_campaign, 0, 1000) {
            $total_bids += scalar @chunk;
            process_banners(\@chunk);
            last if @pending_campaign < 1000 && $cid;
        }

        @pending_campaign = ();
    }
}
}

sub process_banners {
    my ($banners) = @_;

    my $plus18_mask = check_banners_plus18_flag($banners);
    
    my %SET_CONDITION;
    
    my @bids;
    my @magic_queue;
    my @bs_resync_queue;

    my $dbh = get_dbh(PPC);

    for (my $i = 0; $i < @{$banners || [] }; ++$i) {
        my $banner_flags_hash = get_banner_flags_as_hash($banners->[$i]{flags}, 1);
        
        my $changed = 0;
        
        if (!defined $banner_flags_hash->{age}) { #Если нет нормальной метки
            if ($plus18_mask->[$i]) {
                $banner_flags_hash->{plus18} = 1;
                $banner_flags_hash->{age} = 18;
                $changed = 1;
            }
            else {
                $changed = 2 if $banner_flags_hash->{plus18} || $banner_flags_hash->{age};
                delete $banner_flags_hash->{plus18};
                delete $banner_flags_hash->{age};
            }
        }

        next unless $changed;

        push @bids, $banners->[$i]{bid};
        push @magic_queue, _flags_magic_queue_format($banners->[$i]{bid}, $banners->[$i]{cid}, $banner_flags_hash);
        push @bs_resync_queue, [$banners->[$i]{cid}, $banners->[$i]{bid}];

        #$SET_CONDITION .= " WHEN ".$dbh->quote($banners->[$i]{bid})." THEN ".$dbh->quote( serialize_banner_flags_hash($banner_flags_hash) );
        $SET_CONDITION{$banners->[$i]{bid}} =  serialize_banner_flags_hash($banner_flags_hash);
    }
    
    if (@bids) {
        my $case = sql_case(PPC,'bid', \%SET_CONDITION, default__dont_quote => 'flags');

        my $SQL = ["update banners set lastchange = lastchange,
                                       flags = $case",
                    where => { bid => \@bids } ];

        do_sql(PPC, $SQL);
        do_mass_insert_sql(PPC, "insert into moderation_cmd_queue (cmd, cid, data) values %s", \@magic_queue);
        do_mass_insert_sql(PPC, "INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s", \@bs_resync_queue);
    }

}

sub check_banners_plus18_flag
{
    my $banners = shift;

    my @req;
    

    foreach my $banner (@$banners) {
        push @req, {
            body => $banner->{body},
            title => $banner->{title},
            phrases => "",
        };
    }
    
    my $st = time();
    my $cat_res = Yandex::Catalogia::banner_classify(\@req, {timeout => 60});
    
    unless (defined $cat_res) {
        $log->die("Catalogia failed");
    }

    my @result;
    
    if (scalar @{$cat_res || []}) {
        for (my $i = 0; $i < scalar @$banners; $i++) {
            $result[$i] = scalar grep { $_ eq 'plus18' } @{ $cat_res->[$i]->{flag} || [] };
        }
    }

    return \@result;
}

sub _flags_magic_queue_format
{
    my ($bid, $cid, $banner_flags_hash) = @_;

    return ['updateBannerFlags',
             $cid,
             JSON::Syck::Dump(
                                {
                                  bid => $bid,
                                  flags => convert_flags_to_moderation_format($banner_flags_hash),
                                }
                             )
           ];
}

our %AD_WARNINGS = (
    'abortion' => {},
    'medicine' => {},
    'alcohol' =>  {},
    'tobacco' =>  {},
    'age'    =>   {variants => [qw/18 16 12 6 0/], is_common_warn => 1},
);

=head2 get_banner_flags_as_hash

    Функция десериализует поле флагов баннера в хеш

=cut

sub get_banner_flags_as_hash
{
    my ($flags, $all_flags) = @_;
    my %result;

    my @kv = split(/,/, $flags || '');
    
    foreach my $part (@kv) {
        my ($warn_name, $value) = map { lc($_) } split(/:/, $part, 2);
        
        next if !$all_flags && !defined $AD_WARNINGS{$warn_name};

        if (defined $AD_WARNINGS{$warn_name}{variants}) {
            next if !defined $value || !grep { $value eq $_ } @{ $AD_WARNINGS{$warn_name}{variants} };
        }

        $value = 1 unless defined $value;
        $result{$warn_name} = $value;
    }
    
    return \%result;
}

=head2 serialize_banner_flags_hash

Сериализует хеш с флагами для сохранения в базе Директа.

=cut

sub serialize_banner_flags_hash
{
    my ($flags) = @_;
    my @accumulator;

    foreach my $flag (sort keys %$flags) {
        if (defined $AD_WARNINGS{$flag}{variants}) {
            push @accumulator, $flag.":".$flags->{$flag};
        }
        else {
            push @accumulator, $flag;
        }
    }

    return join(",", @accumulator);
}


=head2 convert_flags_to_moderation_format

Конвертирует хеш с флагами в формате Директа в хеш понятный модерации.

=cut

sub convert_flags_to_moderation_format
{
    my ($flags) = @_;
    
    my %result;

    foreach my $flag_name (sort keys %$flags) {
        if ($flag_name eq 'age') {
            my $value = $flags->{$flag_name};
            $result{$flag_name} = "age".$flags->{$flag_name};
        }
        else {
            $result{$flag_name} =  $flags->{$flag_name};
        }
    }
    
    return \%result;
}

