#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => "30 мин",
    comment => q[
        установка цен на фразы в соответствии с аукционом и формулой установки цены по умолчанию
        для фраз с ценой больше 50 у.е. (высокие ставки образовались в результате ошибки)
    ]
}

=cut

use strict;
use warnings;
use utf8;

use Data::Dumper;
use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use BannersCommon;
use Phrase;
use Common;
use Currencies; 
use RBAC2::Extended;
use MailNotification;

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if !defined $rbac || !$rbac->InitReq(1);

use Clone qw/clone/;
use List::Util qw/max min/;
use File::Slurp;

$log->out("start");

# номера bid получены как: 
# perl -I./protected -ME -MList::MoreUtils -e 'join "\n", sort {$a <=> $b} List::MoreUtils::uniq map {@{get_one_column_sql(PPC, "SELECT DISTINCT bid FROM $_ WHERE price > 50") || []}} qw/bids bids_arc/'
#    > deploy/20121224_fix_large_price.txt.data
my @bids = map {chomp; $_} read_file("${Bin}/20121224_fix_large_price.txt.data");
foreach my $bid (@bids) {

    my ($banners, $t) = get_banners({
        bid => [$bid],
    }, {get_auction => 1, get_add_camp_options => 1});
    my $banner = $banners->[0];
    next unless $banner; 

    my %arc_phrases;
    $banner->{Phrases} = [];
    my @old_phrases;
    foreach my $p (@{$banner->{phrases}}) {
        if (is_arc_phrase($banner->{cid}, $p->{id})) {
            if ($p->{price} > 50) {
                $arc_phrases{$$p{id}} = sprintf '%.2f', max $MIN_PRICE, min $MAX_PRICE, $p->{max} * $Common::AUTO_BROKER_INCREASE;
                $log->out(sprintf 'bid %d - old price %f; new price %f', $p->{id}, $p->{price}, $arc_phrases{$$p{id}});     
            }
        } else {            
            my $phrase;
            if ($p->{price} > 50) {
                $phrase = clone($p);
                $phrase->{price} = sprintf '%.2f', max $MIN_PRICE, min $MAX_PRICE, $p->{max} * $Common::AUTO_BROKER_INCREASE;
                $log->out(sprintf 'bid %d - old price %f; new price %f', $phrase->{id}, $p->{price}, $phrase->{price});
            } else {
                $phrase = clone($p); 
            }
            push @{$banner->{Phrases}}, $phrase;
            push @old_phrases, $p;
        }
    }
    
    if (keys %arc_phrases) {
        my $case = sql_case(PPC, id => \%arc_phrases, default => 0);
        do_sql(PPC, ["UPDATE bids_arc SET modtime = modtime, price = $case",
                        WHERE => {id => [keys %arc_phrases], cid => $banner->{cid}}]); 
    }
    
    if (@{$banner->{Phrases}}) {
        
        $banner->{phrases} = \@old_phrases;
        set_yacobot_rubrics($banner);
        $banner->{yaca_unchecked} = [];
        
        my $uid = get_one_field_sql(PPC, 'SELECT uid FROM campaigns WHERE cid = ?', $banner->{cid});
        Tools::_save_vars(undef, $uid);
        MailNotification::save_UID_rbac($uid, $rbac);
        update_banner_phrases($banner->{cid}, $uid, $banner, $banner, $uid);
    }
}

$log->out("finish");

sub is_arc_phrase {
    my ($cid, $id) = @_;
    return get_one_field_sql(PPC, 'SELECT id FROM bids_arc WHERE cid = ? AND id = ?', $cid, $id);
}
