#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '3 hours',
  comment => 'разбиваем таблицу ppclog.user_units_log на отдельные таблицы по дням',
}

=cut

#по замерам на ppcdev на обработку 100_000 записей уходит 4 секунды

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;

use Settings;
use Yandex::DBTools;
use Yandex::DBSchema;

$log->out('START');

my $select_limit = 100_000;
my $insert_limit = 5000;

my @fields = qw(uid scheme rating units);

my $rows_count = get_one_field_sql(PPCLOG, "select count(*) from user_units_log");


get_dbh(PPCLOG_HEAVY)->{mysql_use_result} = 1;

# исхожу из того что в myisam сортировка по-умолчанию (не гарантрованно) идет
# преимущественно по порядку добавления данных, что мне и надо, для массовых вставок
# (ключ по дате отсутствует, и создавать его скорее всего нецелесообразно)

my $sth = exec_sql(PPCLOG_HEAVY, "select *, DATE_FORMAT(log_date, '%Y%m%d') log_date from user_units_log");
$log->out("sql select executed");

my $processed = 0;
my $i = 0;
while (my $rows = $sth->fetchall_arrayref({}, $select_limit)) {
    last unless @$rows;
    my %stat_by_dates = ();
    foreach my $row (@$rows) {
        push(@{$stat_by_dates{$row->{log_date}}}, [map { $row->{$_} } @fields]);
        if (@{$stat_by_dates{$row->{log_date}}} >= $insert_limit) {
            insert_log($row->{log_date}, \%stat_by_dates);
        }
    }
    foreach my $log_date (keys %stat_by_dates) {
        insert_log($log_date, \%stat_by_dates);
    }
    
    $processed += scalar(@$rows);

    $log->out("$processed rows processed");

    last if $processed >= $rows_count;
}
$sth->finish;

$log->out('FINISHED');

sub insert_log {
    my ($log_date, $stat_by_dates) = @_;

    unless (is_table_exists(PPCLOG, "user_units_log_$log_date")) {
        create_table_by_schema(PPCLOG, "user_units_log_$log_date", like => "ppclog.user_units_log_YYYYMMDD", if_not_exists => 1);
    }
    do_mass_insert_sql(PPCLOG, "insert into user_units_log_$log_date
                                            (".join(', ', @fields).")
                                     VALUES %s
                                         on duplicate key update
                                            rating = VALUES(rating),
                                            units = VALUES(units)", 
                               $stat_by_dates->{$log_date});
    delete($stat_by_dates->{$log_date});
}
