#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1,5 минуты',
  comment => 'удаляем переводы строк в конце названий сайтлинков',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Sitelinks ();

use utf8;

$log->out('START');

$log->out('Fetching sitelinks with new line in title');
my $broken_sitelinks = get_all_sql(PPC_HEAVY, q/
    SELECT STRAIGHT_JOIN GROUP_CONCAT(b.bid) AS bids, sl.sl_id, sl.title, sl.href, sl.hash
    FROM sitelinks_links sl
    LEFT JOIN sitelinks_set_to_link ss2l ON ss2l.sl_id = sl.sl_id
    LEFT JOIN  banners b ON b.sitelinks_set_id = ss2l.sitelinks_set_id
    WHERE sl.title LIKE "%\n"
    GROUP BY sl.sl_id
/) || [];

my @bids_for_resync;
$log->out('Got ' . scalar(@$broken_sitelinks) . ' sitelinks');
for my $sl (@$broken_sitelinks) {
    $log->out($sl);
    $sl->{title} =~ s/\n+$//;
    my $new_hash = Sitelinks::_calc_sitelink_hash($sl);
    do_update_table(PPC, 'sitelinks_links', {title => $sl->{title}, hash => $new_hash}, where => {sl_id => $sl->{sl_id}, hash => $sl->{hash}});
    if ($sl->{bids}) {
        my @bids = split /,/, $sl->{bids};
        push @bids_for_resync, @bids;
    }
}

if (@bids_for_resync) {
    $log->out('Resetting statusBsSynced for banners:', \@bids_for_resync);
    do_update_table(PPC, 'banners', {statusBsSynced => 'No'}, where => {bid => \@bids_for_resync});
}

$log->out('FINISH');
