#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "11 минут на test2",
  comment => "перенос тегов с баннеров к группам"
}

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out('start');
do_insert_select_sql(PPC, 'INSERT IGNORE tag_group(tag_id, pid) VALUES %s',
                        'SELECT tb.tag_id, b.pid FROM tag_banner tb JOIN banners b ON tb.bid = b.bid',
                        max_row_for_select => 50000,
                        max_row_for_insert => 10000,
                        sleep => 1);
$log->out('finish');
