#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 минут",
  comment => "восстанавливаем автоброкер, сброшеный через изменение ставок со сраницы статистики",
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::TimeCommon qw/get_distinct_dates today/;
use Tools qw/is_beta/;

use utf8;
use open ':std' => ':utf8';

$log->{tee} = is_beta();

$log->out('START');

my $start_date = '20130131';
my $end_date = '20130205';
my @dates = get_distinct_dates($start_date, $end_date);

my @update;
my $count = 0;
for my $date (@dates) {
    $log->out("date $date");
    my $rows = get_all_sql(PPCLOG, "select cid, param from logcmd_$date where cmd = 'ajaxUpdatePrices'") || [];
    $log->out("found @{[scalar @$rows]} rows");
    for my $row (@$rows) {
        my ($cid, $param) = @{$row}{qw/cid param/};
        my (@fix) = ($param =~ /broker_(\d+_\d+)=1/g);
        next unless @fix;
        for my $fix (@fix) {
            $log->out({ cid => $cid, bid_id => $fix, param => $param });
            push @update, [ $cid, split /_/, $fix];
        }
        if (@update >= 1000) {
            for my $table (qw/bids bids_arc/) {
                my $cnt = int do_sql(PPC, ["update $table set AutoBroker = 'Yes'", where => {
                    cid => [ map { $$_[0] } @update ],
                    bid => [ map { $$_[1] } @update ],
                     id => [ map { $$_[2] } @update ],
                    AutoBroker => 'No',
                }]);
                $log->out("$table : $cnt bids updated");
                $count += $cnt;
            }
            do_mass_insert_sql(PPC, "insert ignore into bs_resync_queue (cid,bid) values %s", [ map { [ $$_[0], $$_[1] ] } @update ]);
            @update = ();
        }
    }
}
if (@update) {
    for my $table (qw/bids bids_arc/) {
        my $cnt = int do_sql(PPC, ["update $table set AutoBroker = 'Yes'", where => {
            cid => [ map { $$_[0] } @update ],
            bid => [ map { $$_[1] } @update ],
             id => [ map { $$_[2] } @update ],
            AutoBroker => 'No',
        }]);
        $log->out("$table : $cnt bids updated");
        $count += $cnt;
    }
    do_mass_insert_sql(PPC, "insert ignore into bs_resync_queue (cid,bid) values %s", [ map { [ $$_[0], $$_[1] ] } @update ]);
}

$log->out("total bids updated: $count");

# <ВАШ КОД>

$log->out('FINISH');

