#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1,5 минуты',
  comment => 'Переотправляем в модерацию потерянные лицензии'
}

=cut

#DIRECT-20520 - Файлы пользовательских лицензий из Директа не приходят в модерацию

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Data::Dumper;
use ModerationQueue;

my $i = 1;

$log->out("START");

while (<DATA>) {
    chomp;
    my ($path, $uid, $cid, $type) = split(/\t/);

    my $filename = join('.', "lic_".$i++, $type);
    my $data = {filename => $filename, uid => $uid, path => $path, cid => $cid};
    
    unless($cid) {
        $log->out("No cid for uid=$uid path = $path");
        next;
    }

    $log->out("sending file=$filename uid=$uid cid=$cid path=$path");

    ModerationQueue::push_moderate_queue('AddDocument', $cid, $data);
}

$log->out("END");

__DATA__
2316	154867729	4575513	jpg
2320	154867729	4575513	jpg
2321	154867729	4575513	jpg
11668	67181056	5436578	jpg
11669	157603525	5890852	jpg
11670	149197433	5911514	pdf
11671	157603525	5890852	jpg
11672	67181056	5436578	jpg
11673	157603525	5890852	jpg
11674	157603525	5890852	jpg
11675	157603525	5890852	jpg
11676	67181056	5436578	jpg
11677	67181056	5436578	jpg
11678	67181056	5436578	jpg
21140	146667846	5460530	jpg
21141	146667846	5460530	bin
21142	146667846	5460530	pdf
21143	146667846	5460530	jpg
21144	146667846	5460530	jpg
21145	146667846	5460530	bin
21146	146667846	5460530	pdf
21147	146667846	5460530	jpg
21148	146667846	5460530	bin
21149	146667846	5460530	jpg
21150	172920434	5267718	pdf
21151	172920434	5267718	pdf
21152	172920434	5267718	pdf
21153	172920434	5267718	pdf
21154	47563914	5439710	pdf
21155	173251443	5775997	jpg
21156	173251443	5775997	jpg
21157	173258287	5269281	jpg
21159	122671353	5270595	jpg
21160	30652051	5271196	jpg
21161	30652051	5271196	jpg
21162	30652051	5271196	jpg
21163	173304334	5271281	jpg
21165	33207876	5272197	rar
21171	92060077	5275366	jpg
22586	159968386	4523713	pdf
23293	162921596	5589667	pdf
24956	169722267	5199633	jpg
35859	87676687	5695414	jpg
35860	87676687	5695414	jpg
35861	87676687	5695414	jpg
35862	87676687	5695414	jpg
35863	87676687	5695414	jpg
35886	31331114	5715954	jpg
35887	31331114	5715954	jpg
35888	31331114	5715954	jpg
35891	77165881	5928337	jpg
35895	192594291		jpg
35896	192698952	5698030	jpg
35897	2879701	5679254	jpg
35898	2879701	5679254	jpg
35902	59857765	5698407	jpg
35903	59857765	5698407	jpg
35904	59857765	5698407	jpg
35959	91681079	5699418	pdf
35960	91681079	5699418	jpg
35961	91681079	5699418	pdf
36154	185594016	5704424	jpg
36162	159778	5707869	jpg
36173	63610623	5705230	rar
36225	23783659	5705463	jpg
36226	23783659	5705463	jpg
36227	165571943	5833154	jpg
36228	165571943	5833154	jpg
36244	165571943	5833154	jpg
36293	163787521	5824853	pdf
36294	163787521	5824853	pdf
36295	163787521	5824853	pdf
36296	163787521	5824853	pdf
36297	192852134	5707816	jpg
36298	192852134	5707816	jpg
36299	192852134	5707816	jpg
36300	192852134	5707816	jpg
36321	64471250	3975843	jpg
36364	192954548	5709628	jpg
36365	192954548	5709628	jpg
36366	192954548	5709628	jpg
36367	24861163	5709764	pdf
36368	24861163	5709764	pdf
36369	24861163	5709764	pdf
36371	24861163	5709764	pdf
36372	24861163	5709764	pdf
36373	24861163	5709764	pdf
36379	192970746	5710005	jpg
36380	192970746	5710005	jpg
36381	192970746	5710005	jpg
36421	192939740	5711053	jpg
36422	192947725	5711093	jpg
36427	191965653	5711296	jpg
36431	187279991	5711404	jpg
36432	191087664	5686058	jpg
36440	48987464	5730801	jpg
36441	48987464	5730801	jpg
36442	48987464	5730801	jpg
36452	193076448	5740121	jpg
36453	193076448	5740121	jpg
36456	191086894	5713822	pdf
36457	90522138	5715643	png
36458	90522138	5715643	png
36521	193151372	5717218	jpg
36538	114661458	5717785	jpg
36643	44063310	5719689	jpg
36687	155536126	5720612	jpg
36688	155536126	5720612	jpg
36689	155536126	5720612	jpg
36690	155536126	5720612	jpg
36691	155536126	5720612	jpg
36707	117867774	5721443	jpg
36708	117867774	5721443	jpg
36709	117867774	5721443	jpg
36710	117867774	5721443	jpg
36711	117867774	5721443	jpg
36712	117867774	5721443	jpg
36713	117867774	5721443	jpg
36714	117867774	5721443	jpg
36715	117867774	5721443	jpg
36716	117867774	5721443	jpg
36717	117867774	5721443	jpg
36718	117867774	5721443	jpg
36719	117867774	5721443	jpg
36720	117867774	5721443	jpg
36721	117867774	5721443	jpg
36766	159106269	5908246	jpg
36767	159106269	5908246	jpg
36768	159106269	5908246	jpg
36769	159106269	5908246	jpg
36807	92927792	5723195	bin
36830	193268895	5723987	jpg
36878	193282753	5724945	jpg
36907	130627371	5725977	jpg
36923	191110059	5681173	jpg
36951	171956752	5789037	jpg
36952	171956752	5789037	jpg
36953	171956752	5789037	jpg
36971	83638853	5929041	jpg
36972	83638853	5929041	jpg
36985	193076448	5740121	jpg
37260	192230962	5737251	pdf
37261	192230962	5737251	zip
37262	46714136	5791588	jpg
37263	46714136	5791588	jpg
37287	135713119	5917205	zip
37292	34255048	5733427	jpg
37308	193424030	5784025	pdf
37309	193424030	5784025	jpg
37310	193424030	5784025	jpg
37311	193424030	5784025	pdf
37320	193476331	5734024	rar
37321	193476331	5734024	jpg
37323	40586616	5734086	jpg
37432	16332756	5734117	pdf
37433	16332756	5734117	rar
37434	16332756	5734117	pdf
37464	193544423	5737170	bmp
37545	76954035	5738330	pdf
37546	193584764	5739236	jpg
37604	193076448	5740121	jpg
37611	193617957	5740445	jpg
37624	105684964	5741507	jpg
37625	105684964	5741507	jpg
37639	103877605	5741830	jpg
37664	14321494	5742190	jpg
37668	193331261	5742857	jpg
37708	193550097	5743550	jpg
37709	193550097	5743550	jpg
37710	192084759	5744025	jpg
37715	193747055	5744053	jpg
37716	102585346	5794141	jpg
37727	102585346	5794141	jpg
37728	102585346	5794141	jpg
37729	102585346	5794141	jpg
37730	102585346	5794141	jpg
37733	176416350	5744232	png
37740	77756360	5744444	jpg
37816	160432231	5869666	jpg
37847	170490848	5747945	jpg
38045	142232983	5772236	jpg
38046	142232983	5772236	jpg
38062	142232983	5772236	jpg
38063	142232983	5772236	jpg
38064	142232983	5772236	pdf
38065	142232983	5772236	jpg
38066	142232983	5772236	pdf
38067	142232983	5772236	pdf
38068	142232983	5772236	jpg
38077	193955822	5752877	jpg
38120	118876136	5753754	zip
38126	193944659	5753883	pdf
38127	193944659	5753883	pdf
38201	192325864	5754529	jpg
38202	192325864	5754529	jpg
38203	192325864	5754529	jpg
38204	194000192	5754639	pdf
38205	194000192	5754639	pdf
38206	194000192	5754639	pdf
38207	194000192	5754639	pdf
38208	194000192	5754639	pdf
38209	26970569	5907089	jpg
38210	193420272	5839368	pdf
38218	193924952	5751444	jpg
38252	194041677	5756551	jpg
38253	194041677	5756551	jpg
38254	194041677	5756551	jpg
38255	194041677	5756551	jpg
38256	194041677	5756551	jpg
38274	138856182	5756582	zip
38287	184048119	5748545	zip
38360	194072962	5758260	jpg
38361	194072962	5758260	jpg
38362	194072962	5758260	jpg
38409	187088250	5755696	jpg
38423	172210712	5763820	pdf
38441	194100213	5759076	png
38470	192798684	5782527	jpg
38472	63110087	5759893	gif
38475	193148340	5760122	jpg
38499	194140012		jpg
38500	194140012		jpg
38501	194140012		pdf
38502	194140012		jpg
38503	194140012		pdf
38504	194140012		jpg
38505	194140012		pdf
38506	194140012		jpg
38507	194140012		jpg
38511	184048119	5748545	jpg
38512	184048119	5748545	jpg
38513	184048119	5748545	jpg
38514	184048119	5748545	jpg
38515	184048119	5748545	jpg
38567	184048119	5748545	jpg
38568	184048119	5748545	jpg
38569	184048119	5748545	jpg
38570	184048119	5748545	jpg
38583	125986259	5368380	jpg
38584	67250735	4524185	jpg
38585	67250735	4524185	jpg
38586	194158805	5761772	jpg
38624	121333330	5819653	pdf
38625	121333330	5819653	pdf
38626	121333330	5819653	pdf
38627	121333330	5819653	pdf
38628	121333330	5819653	pdf
38632	172210712	5763820	pdf
38636	186201975	5739530	jpg
38637	186201975	5739530	jpg
38638	186201975	5739530	jpg
38643	96587779	5758578	jpg
38647	134832896	5762845	jpg
38800	163190115		jpg
38801	192732106	5768794	pdf
38822	129012798	5769375	png
38832	71878055	5769599	jpg
38849	142232983	5772236	pdf
38850	142232983	5772236	pdf
38851	142232983	5772236	pdf
38852	142232983	5772236	jpg
38853	142232983	5772236	jpg
38854	194432200	5770988	png
38855	194432200	5770988	bin
38888	148970015	5771623	jpg
38901	194468817	5771845	jpg
38909	194355265	5769214	jpg
38910	192513517	5820275	png
38911	137057183	5821013	jpg
38912	137057183	5821013	jpg
38913	137057183	5821013	jpg
38958	193315217	5773419	jpg
38959	193315217	5773419	jpg
39060	183376805	5880757	jpg
39061	183376805	5880757	jpg
39062	183376805	5880757	jpg
39083	36920448	5776837	jpg
39086	129716497	5906715	jpg
39102	194608823	5776890	pdf
39105	194608314	5882396	jpg
39145	194611659		jpg
39146	194611659		zip
39147	194611659		jpg
39219	21448183	5778467	png
39250	194661197	5778826	jpg
39251	194608649	5777346	jpg
39262	194695272	5788800	jpg
39319	194712690	5781231	jpg
39336	194650505	5778693	jpg
39356	88830835	5891320	pdf
39357	88830835	5891320	pdf
39358	88830835	5891320	jpg
39372	192106070	5709866	png
39383	59103174	5840518	jpg
39384	59103174	5840518	jpg
39385	146463553	5782928	pdf
39386	146463553	5782928	pdf
39387	146463553	5782928	pdf
39388	146463553	5782928	pdf
39389	146463553	5782928	pdf
39394	157603525	5890852	jpg
39402	176302755	5783195	jpg
39403	194666131	5778927	jpg
39417	193416975	5731160	zip
39419	193416975	5731160	zip
39424	194791175	5783739	pdf
39448	159043077	5920377	pdf
39461	183512904	5784329	jpg
39553	87287218	5785459	jpg
39554	87287218	5785459	jpg
39555	87287218	5785459	jpg
39556	44898369	5785462	jpg
39557	44898369	5785462	jpg
39569	194862352	5786145	jpg
39619	25893292	5786953	jpg
39647	88830835	5891320	jpg
39648	88830835	5891320	pdf
39649	88830835	5891320	pdf
39650	88830835	5891320	jpg
39676	158758646	5788485	jpg
39677	57376256	5848617	jpg
39680	194526434	5789414	pdf
39681	194526434	5789414	pdf
39682	194526434	5789414	pdf
39683	194526434	5789414	pdf
39684	194526434	5789414	pdf
39685	194526434	5789414	pdf
39686	194526434	5789414	pdf
39687	194526434	5789414	pdf
39688	194526434	5789414	pdf
39689	194526434	5789414	pdf
39690	194526434	5789414	pdf
39691	194526434	5789414	pdf
39805	194861144	5786088	jpg
39872	195001094	5790522	jpg
39873	183446915	5875432	pdf
39878	195042956	5791475	bin
39879	46714136	5791588	jpg
39882	195054397	5791697	jpg
39890	195081862	5792075	jpg
39891	195084684	5792129	jpg
39908	194510730	5792792	bin
39910	193270422	5796927	jpg
39911	193270422	5796927	bin
39912	193270422	5796927	jpg
39913	193270422	5796927	jpg
39937	195302034	5795335	jpg
39955	195384974	5797140	jpg
39956	186026217	5798054	bin
39957	186026217	5798054	jpg
39961	174145921	5798424	zip
39962	72871355	5854210	jpg
39967	195460041	5798635	pdf
39968	195460041	5798635	jpg
40065	124887779	5919506	jpg
40072	93728573	5890258	jpg
40073	157362933	5898864	jpg
40074	131229613	5800025	jpg
40075	194834077	5800174	pdf
40076	47477393	5906045	jpg
40086	195403535	5797351	jpg
40093	195582358	5861730	jpg
40094	195582358	5861730	jpg
40095	15314172	5916145	png
40096	97280949	5801823	png
40097	181985904	5802048	jpg
40098	193726831	5802066	jpg
40115	195694226	5829264	jpg
40116	195694226	5829264	jpg
40117	22494017	2843859	zip
40118	190452665	5805399	jpg
40128	163181362	5805063	jpg
40129	163181362	5805063	jpg
40130	190452665	5805399	png
40131	190452665	5805399	jpg
40132	190452665	5805399	png
40133	190452665	5805399	pdf
40134	190452665	5805399	pdf
40135	194099038	5816651	jpg
40136	195820090	5805816	jpg
40185	185562813	5808746	jpg
40195	118386618	5863664	rar
40209	195744402	5804279	jpg
40220	35240995	5810236	jpg
40221	35240995	5810236	jpg
40222	35240995	5810236	jpg
40223	195954209	5817196	zip
40231	194346787	5847449	jpg
40236	20391465	5810142	jpg
40272	134261770	5925386	rar
40278	195751022	5804466	jpg
40326	194099038	5816651	jpg
40345	196029674	5812745	jpg
40346	196035547		jpg
40347	196035547		jpg
40348	196035547		jpg
40355	2631265	5813187	jpg
40378	91824250	5813439	jpg
40379	194099038	5816651	jpg
40418	195998887	5811709	jpg
40449	52759818	5811891	jpg
40462	196132125	5816495	jpg
40463	34431205		zip
40464	186025831	5816494	jpg
40465	186025831	5816494	jpg
40466	186025831	5816494	jpg
40479	105401644	5816968	jpg
40480	196103233	5818248	jpg
40481	90356436	5817223	jpg
40539	46300231	5818533	jpg
40706	58976568	5819684	jpg
40707	58976568	5819684	jpg
40708	58976568	5819684	jpg
40709	58976568	5819684	jpg
40714	157362933	5898864	jpg
40728	191045966	5822230	pdf
40749	172013657	5823731	jpg
40752	196370804	5824075	jpg
40777	194454225	5824613	jpg
40780	19834841	5825213	pdf
40787	195694226	5829264	pdf
40788	195694226	5829264	jpg
40789	195694226	5829264	pdf
40790	82974196	5923725	jpg
40791	82974196	5923725	jpg
40792	82974196	5923725	jpg
40793	82974196	5923725	jpg
40794	82974196	5923725	jpg
40795	157362933	5898864	jpg
40796	157362933	5898864	jpg
40804	87288613	5826782	jpg
40805	87288613	5826782	jpg
40806	87288613	5826782	jpg
40809	11759383	5827020	jpg
40810	11759383	5827020	jpg
40811	11759383	5827020	jpg
40812	11759383	5827020	jpg
40816	139985233		rar
40871	84572881	5828329	jpg
40878	194909817	5845367	pdf
40901	196471837	5828897	jpg
40904	162296027	5829308	pdf
40905	162296027	5829308	pdf
40906	162296027	5829308	pdf
40918	196447847	5829499	pdf
40919	196447847	5829499	pdf
40929	196518499	5913537	zip
40970	193944428	5830950	jpg
40971	193944428	5830950	jpg
41082	196499577	5833037	jpg
41084	160647016	5832990	jpg
41094	165571943	5833154	jpg
41143	161704725	5833982	jpg
41144	161704725	5833982	jpg
41187	136004217	5876001	jpg
41188	11373215	5834503	jpg
41189	11373215	5834503	jpg
41190	11373215	5834503	jpg
41191	193713847	5835575	bin
41219	196353600	5889452	bin
41220	196353600	5889452	bin
41221	196353600	5889452	jpg
41222	47477393	5906045	jpg
41231	196720076	5837923	jpg
41254	20026201	5838562	jpg
41255	20026201	5838562	jpg
41256	20026201	5838562	jpg
41257	20026201	5838562	jpg
41258	20026201	5838562	jpg
41330	196756573	5839451	jpg
41503	196819227	5842124	jpg
41504	196819227	5842124	jpg
41505	196819227	5842124	jpg
41506	196819227	5842124	jpg
41519	72027209	5902720	bin
41541	194909817	5845367	pdf
41542	174458166	5845577	jpg
41543	174458166	5845577	jpg
41544	174458166	5845577	jpg
41545	174458166	5845577	jpg
41546	174458166	5845577	jpg
41547	47477393	5906045	jpg
41548	186599283	5845863	jpg
41558	174849543	5846057	jpg
41672	195405969	5797384	jpg
41710	177189349	5826656	jpg
41711	177189349	5826656	jpg
41720	196733848	5849646	jpg
41729	47477393	5906045	jpg
41730	183022440	5849839	jpg
41731	183022440	5849839	jpg
41732	183022440	5849839	jpg
41733	183022440	5849839	jpg
41734	183022440	5849839	jpg
41735	155304034	5850132	jpg
41743	195424777	5881465	jpg
41744	18229252	5851343	jpg
41745	18229252	5851343	jpg
41746	18229252	5851343	jpg
41747	195424777	5881465	jpg
41748	195424777	5881465	jpg
41749	195424777	5881465	jpg
41750	195424777	5881465	jpg
41751	195424777	5881465	jpg
41752	195424777	5881465	jpg
41753	197084483	5851894	jpg
41754	57752975	5926502	jpg
41755	57752975	5926502	jpg
41756	57752975	5926502	jpg
41757	57752975	5926502	jpg
41758	195424777	5881465	jpg
41759	195424777	5881465	jpg
41760	196733848	5849646	jpg
41761	195424777	5881465	jpg
41762	195424777	5881465	jpg
41763	195424777	5881465	jpg
41764	195424777	5881465	png
41765	195424777	5881465	jpg
41766	195424777	5881465	jpg
41767	195424777	5881465	jpg
41769	197131764	5853089	jpg
41770	195424777	5881465	jpg
41771	195424777	5881465	jpg
41772	195424777	5881465	jpg
41773	195424777	5881465	jpg
41774	195424777	5881465	jpg
41775	195424777	5881465	jpg
41776	195424777	5881465	png
41777	195424777	5881465	jpg
41778	195424777	5881465	jpg
41779	195424777	5881465	jpg
41780	195424777	5881465	png
41781	195424777	5881465	jpg
41782	195424777	5881465	jpg
41783	195424777	5881465	jpg
41784	195424777	5881465	jpg
41785	195424777	5881465	png
41786	195424777	5881465	jpg
41787	195424777	5881465	jpg
41788	195424777	5881465	jpg
41789	195424777	5881465	jpg
41790	195424777	5881465	jpg
41791	195424777	5881465	jpg
41792	195424777	5881465	jpg
41793	195424777	5881465	jpg
41794	195424777	5881465	jpg
41795	195424777	5881465	jpg
41796	195424777	5881465	jpg
41797	195424777	5881465	jpg
41798	195424777	5881465	jpg
41799	195424777	5881465	jpg
41800	195424777	5881465	jpg
41801	195424777	5881465	jpg
41802	195424777	5881465	jpg
41803	195424777	5881465	jpg
41804	195424777	5881465	jpg
41866	94707821	5861106	pdf
41884	80562632	5855422	jpg
41891	31700197	5855857	pdf
41997	195424777	5881465	jpg
41998	195424777	5881465	jpg
41999	195424777	5881465	jpg
42000	195424777	5881465	jpg
42001	195424777	5881465	jpg
42002	194334093	5871473	jpg
42003	195424777	5881465	jpg
42004	195424777	5881465	jpg
42005	195424777	5881465	jpg
42006	195424777	5881465	jpg
42007	195424777	5881465	jpg
42014	115180362	5856905	jpg
42031	197263312	5921754	jpg
42032	197263312	5921754	jpg
42033	197263312	5921754	jpg
42034	197263312	5921754	jpg
42035	197263312	5921754	jpg
42040	197263312	5921754	jpg
42041	197263312	5921754	jpg
42042	197263312	5921754	jpg
42043	197263312	5921754	jpg
42044	197263312	5921754	png
42045	197263312	5921754	jpg
42046	197263312	5921754	jpg
42047	197263312	5921754	jpg
42048	197263312	5921754	jpg
42049	197263312	5921754	jpg
42058	197238428	5855742	pdf
42059	197263312	5921754	jpg
42060	197263312	5921754	jpg
42061	197263312	5921754	jpg
42062	197263312	5921754	jpg
42063	197263312	5921754	jpg
42081	197263312	5921754	jpg
42082	197263312	5921754	jpg
42083	197263312	5921754	jpg
42084	197263312	5921754	jpg
42085	197263312	5921754	jpg
42086	197263312	5921754	jpg
42087	197263312	5921754	jpg
42088	197263312	5921754	jpg
42089	197263312	5921754	jpg
42090	197263312	5921754	jpg
42105	197263312	5921754	jpg
42106	197263312	5921754	jpg
42107	197263312	5921754	jpg
42108	197263312	5921754	jpg
42109	197263312	5921754	jpg
42110	197263312	5921754	jpg
42111	197263312	5921754	jpg
42112	197263312	5921754	jpg
42113	197263312	5921754	jpg
42114	197263312	5921754	jpg
42124	197284905	5858098	jpg
42133	197263312	5921754	jpg
42134	197263312	5921754	jpg
42135	197263312	5921754	jpg
42136	197263312	5921754	jpg
42137	197263312	5921754	jpg
42145	197256937	5856960	pdf
42146	197263312	5921754	jpg
42147	197263312	5921754	jpg
42148	197263312	5921754	jpg
42149	197263312	5921754	jpg
42150	197263312	5921754	jpg
42196	167630803	5858959	jpg
42198	160010121	5859963	jpg
42199	133560097	5860062	jpg
42200	133560097	5860062	jpg
42201	133560097	5860062	jpg
42202	133560097	5860062	jpg
42203	133560097	5860062	jpg
42204	131270901	5860086	jpg
42372	195424777	5881465	jpg
42373	195424777	5881465	jpg
42374	195424777	5881465	jpg
42375	195424777	5881465	jpg
42376	195424777	5881465	jpg
42385	191824596	5843902	pdf
42386	191824596	5843902	pdf
42387	191824596	5843902	pdf
42390	126704530	5863435	pdf
42394	170456663	5863544	jpg
42395	170456663	5863544	jpg
42396	170456663	5863544	jpg
42397	170456663	5863544	jpg
42406	73507973	5863852	jpg
42415	183365904	5864519	jpg
42416	195424777	5881465	jpg
42417	197344855	5864856	jpg
42442	187510468	5915953	jpg
42461	95476847	5866688	jpg
42476	95410218	5866518	jpg
42477	95410218	5866518	jpg
42478	95410218	5866518	jpg
42479	95410218	5866518	jpg
42480	95410218	5866518	jpg
42497	197497277	5867065	jpg
42498	197497277	5867065	jpg
42535	47714510	5867924	bmp
42547	197368547	5869115	pdf
42548	128562650	5869800	png
42668	197252807	5870953	pdf
42716	77505503	5873250	bin
42726	195424777	5881465	jpg
42727	195424777	5881465	jpg
42728	195424777	5881465	jpg
42729	192552453	5875207	jpg
42846	136004217	5876001	jpg
42956	195424777	5881465	jpg
42957	195424777	5881465	jpg
42958	195424777	5881465	jpg
42997	195424777	5881465	jpg
42998	195424777	5881465	jpg
42999	195424777	5881465	jpg
43008	22190890	5812566	jpg
43009	22190890	5812566	jpg
43010	22190890	5812566	jpg
43011	22190890	5812566	jpg
43012	22190890	5812566	jpg
43039	181739987	5878126	jpg
43043	196523986	5878748	pdf
43044	196523986	5878748	pdf
43047	196384663	5879299	jpg
43119	123473539	5900650	jpg
43133	197893051	5880988	jpg
43134	197893051	5880988	jpg
43135	118469975	5881791	gif
43136	23470903	5881257	png
43143	17673503	5881601	jpg
43144	192182886	5881704	jpg
43145	52146421	5882101	jpg
43146	197326647	5882349	jpg
43147	197326647	5882349	jpg
43148	197326647	5882349	jpg
43149	197263312	5921754	jpg
43150	197263312	5921754	jpg
43151	197263312	5921754	jpg
43152	197943162	5882551	jpg
43153	197943162	5882551	jpg
43154	197943162	5882551	png
43155	197943162	5882551	jpg
43156	197943162	5882551	jpg
43157	197943162	5882551	jpg
43158	197943162	5882551	jpg
43159	197943162	5882551	jpg
43160	197943162	5882551	jpg
43161	197943162	5882551	jpg
43162	197943162	5882551	jpg
43163	197943162	5882551	jpg
43164	197943162	5882551	jpg
43166	197943162	5882551	jpg
43167	197943162	5882551	jpg
43168	197943162	5882551	jpg
43169	197943162	5882551	jpg
43170	197943162	5882551	jpg
43173	42592315	5882808	jpg
43174	42592315	5882808	jpg
43175	42592315	5882808	jpg
43176	42592315	5882808	jpg
43177	42592315	5882808	jpg
43200	114724068	5922998	png
43201	114724068	5922998	jpg
43202	114724068	5922998	jpg
43203	114724068	5922998	jpg
43204	114724068	5922998	jpg
43205	198026556	5884380	jpg
43206	130851023	5884596	jpg
43215	197594386	5870935	jpg
43216	197594386	5870935	jpg
43233	101257512	5885795	jpg
43292	198070253	5886769	jpg
43294	180819097	5887060	jpg
43295	27425898	5920429	jpg
43296	27425898	5920429	jpg
43297	27425898	5920429	jpg
43298	27425898	5920429	jpg
43315	194905579	5887928	png
43316	193300396	5888379	jpg
43317	197656376	5888995	jpg
43322	197656376	5888995	jpg
43341	198143513	5889826	gif
43342	198143513	5889826	gif
43343	198143513	5889826	gif
43364	21882670	5890730	jpg
43365	21882670	5890730	jpg
43366	21882670	5890730	jpg
43367	21882670	5890730	jpg
43368	21882670	5890730	jpg
43369	91615193	5911039	jpg
43370	91615193	5911039	png
43374	78905979	5784367	jpg
43381	11000993	5890818	jpg
43382	11000993	5890818	jpg
43383	11000993	5890818	jpg
43487	164696800	5886752	pdf
43506	123473539	5900650	jpg
43516	28497361	5895141	bin
43576	187156174	5930671	jpg
43610	23716651	5897311	jpg
43611	198071875	5886651	jpg
43622	57926036	5926342	jpg
43635	198317644	5898387	png
43645	162312814	5898292	png
43646	162312814	5898292	png
43697	157362933	5898864	bin
43698	157362933	5898864	jpg
43699	157362933	5898864	jpg
43700	157362933	5898864	bin
43701	157362933	5898864	jpg
43702	157362933	5898864	jpg
43703	157362933	5898864	bin
43704	157362933	5898864	jpg
43705	157362933	5898864	jpg
43706	157362933	5898864	bin
43707	157362933	5898864	jpg
43708	157362933	5898864	jpg
43709	157362933	5898864	bin
43710	157362933	5898864	jpg
43711	157362933	5898864	jpg
43716	198289708	5899701	jpg
43717	191482200	5899416	jpg
43718	191482200	5899416	jpg
43719	191482200	5899416	jpg
43720	191482200	5899416	jpg
43796	195491305	5902205	pdf
43847	72027209	5902720	pdf
43848	72027209	5902720	pdf
43908	161644897	5903300	jpg
43931	12327938	5903337	jpg
43932	12327938	5903337	jpg
43989	198312027	5898194	jpg
43990	198436035	5904325	jpg
43993	346352	5904624	pdf
44014	6599633	5898247	jpg
44015	6599633	5898247	jpg
44016	6599633	5898247	jpg
44017	198218096	5905194	jpg
44018	198489890	5906527	zip
44026	198492732	5906686	jpg
44066	198511719	5911691	jpg
44081	66066829	5908667	jpg
44185	57897829	5910601	jpg
44186	198584121	5910798	jpg
44187	7043425	5911253	jpg
44188	198511719	5911691	png
44193	11590283	5911930	bin
44216	198535349	5912382	jpg
44217	198506709	5912390	jpg
44218	198506709	5912390	jpg
44219	198506709	5912390	jpg
44220	198506709	5912390	jpg
44239	198194498	5913087	jpg
44260	142074994	5913394	jpg
44267	198672329	5913400	jpg
44312	49710587	5913968	jpg
44313	49710587	5913968	jpg
44314	49710587	5913968	jpg
44315	49710587	5913968	jpg
44316	49710587	5913968	jpg
44317	120042143	5914308	jpg
44341	198552662	5914789	tiff
44354	105142791	5914703	bin
44358	187510468	5915953	jpg
44374	15314172	5916145	jpg
44503	197954603	5920275	jpg
44504	197954603	5920275	jpg
44523	198773350	5921429	pdf
44524	198773350	5921429	pdf
44546	28887808	5921388	jpg
44547	28887808	5921388	jpg
44566	195069832	5924455	bin
44590	198942623	5925281	jpg
44591	198942623	5925281	jpg
44592	198942623	5925281	jpg
44595	74149916	5925585	zip
44596	198949688	5925750	jpg
44597	198949688	5925750	jpg
44598	198949688	5925750	jpg
44627	57926036	5926342	jpg
44631	48806083	5925966	jpg
44718	93097753	5928317	jpg
44719	4955697	5929070	pdf
44721	35873158	5929161	pdf
44722	35873158	5929161	pdf
44723	35873158	5929161	pdf
44727	187156174	5930671	jpg
44820	98280649	5933181	jpg
44834	163075224	5933266	jpg
44835	163075224	5933266	jpg
44853	194266742	5934724	jpg
44854	133874090	5933936	jpg
44855	37040934	2579097	jpg
44856	37040934	2579097	jpg
44857	37040934	2579097	jpg
44869	199047547	5930922	pdf
44870	199047547	5930922	jpg
44936	82225169	3060995	jpg
44937	82225169	3060995	jpg
44938	82225169	3060995	jpg
