#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
[
{
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 sec",
  sql => "CREATE TABLE IF NOT EXISTS shard_inc_pid (
    pid int unsigned not null PRIMARY KEY  auto_increment, 
    ClientID int unsigned not null, 
    index(ClientID)
  )"
},
{
    type => 'manual',
    when => 'instructions',
    instructions => 'см. описание',
    time_estimate => '10 минут до пакетов, 15 минут после',
    text => q!

    1. Инициализируем таблицу shard_inc_pid достаточно большим pid'ом
На один из  ppcback'ов вылжить пакет yandex-direct-deploy-files релизной версии 
Важно: выкладывать только этот один пакет, остальной Директ не обновлять.
Выполнить скрипт, 2 секунды 
    
    perl -I/var/www/ppc.yandex.ru/protected /opt/ppc-data/deploy-files/deploy/20130214_shard_ad_groups.pl --inc

    Следующий пункт нужно делать сразу же после первого, пауза не больше 5 минут, если что - можно перезапустить

    2. Меняем offset'ы в shard_inc_pid и phrases, чтобы во время выкладки не было коллизий

  В базе ppc 
  lm ppcdata1 sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 1;'

  В базе ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 2; set global auto_increment_offset = 2;'

  на одном из ppcback
  direct-clus PERL apache-reload

  Для контроля: 
  в базе ppc 
  select max(pid) from phrases;
  ждем минуты 2-3, затем смотрим, как распределяются новые pid'ы: 
  select pid % 2, count(*) from phrases where pid > <max(pid) из предыдущего запроса> group by 1
  количество четных pid'ов должно остановиться и не расти. 
  Если продолжает расти через 5-6 минут -- это серьезная проблема, выкладку отменяем, думаем. 


  3. Пакеты
  
  Проверяем, что pid'ы во phrases перестали выдаваться: 
  в базе ppc 
  select max(pid) from phrases;
  ждем минуты 2-3, затем смотрим, как распределяются новые pid'ы: 
  select pid % 2, count(*) from phrases where pid > <max(pid) из предыдущего запроса> group by 1
  количество нечетных pid'ов должно остановиться и не расти (четность, на которую смотрим, в п. 2 и 4 противоположная).
  (Сначала получали только нечетные pid из phrases, теперь получаем только четные из shard_inc_pid)
  Если продолжает расти через 5-6 минут -- это серьезная проблема, думаем (варианты: откатываемся; или пропускаем этот шаг, выполняем все дальше и потом ищем источник старых pid'ов). Лучше всего откатиться. 

  4. Меняем offset'ы обратно:
  
  на мастере ppcdata1
  lm ppcdata1 sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на мастере ppcdict
  lm ppcdict sql 'set global auto_increment_increment = 1; set global auto_increment_offset = 1;'

  на одном из ppcback
  direct-clus PERL apache-reload

  5. Меняем mgid'ы на старых баннерах
  Проконтролировать, что выдача идет из шарда уже не получится, только если смотреть, что нет общих id, уже после работы скрипта:
    select count(*) from media_groups mg join phrases p on p.pid = mg.mgid;
    должно быть 0
  Если не 0 - откатываемся, разбираемся.

  скрипт, около 2 минут: 
  /var/www/ppc.yandex.ru/deploy/20130214_shard_ad_groups.pl


Если придется откатывать полностью выложенный релиз: 
Установить разные оффсеты на ppc и ppcdict (п. 2), 
откатить пакеты, 
вернуть offset=1 для ppc и ppcdict (п.4)

Повторная выкладка: 
в целом все надо повторить, но точную инструкцию надо будет составлять с учетом возникших проблем и того, насколько полностью все выложили в первый раз. 
    !,
},
]

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;
use Yandex::ListUtils qw/chunks/;
use Tools qw/is_beta/;
use ScriptHelper;
use Getopt::Long;

use utf8;

my $INIT_INCREMENT = 0;
GetOptions("inc" => \$INIT_INCREMENT);

$log->{tee} = is_beta();
$log->out('START');

if ($INIT_INCREMENT) {
    # в среднем в середине дня выдается 800 новых pid в минуту
    my $OFFSET = 80_000;
    my $max_pid = get_one_field_sql(PPC, "select max(pid)+$OFFSET from phrases");
    $log->out("init auto_increment with $max_pid");
    do_sql(PPCDICT, "replace into shard_inc_pid values ($max_pid,0)");
    $log->out("FINISH");
    exit;
}

my $mgids = get_one_column_sql(PPC, "select mgid from media_groups where mgid < 100000 order by mgid");
for my $chunk (chunks $mgids, 1000) {
    $log->out("progress: chunk start at $$chunk[0]");
    my $pids = get_new_id_multi('pid', scalar @$chunk, ClientID => 0);
    $log->die("failed to get pids") unless @$chunk == @$pids;
    $log->out({ map { $chunk->[$_] => $pids->[$_] } (0 .. $#$pids) } );
    my $mgid_pid_case = sql_case(PPC, 'mgid', { map { $chunk->[$_] => $pids->[$_] } (0 .. $#$pids) } );
    relaxed times => 2, sub {
        do_in_transaction {
            for my $table (qw/media_groups media_banners media_auto_moderate mcb_phrases/) {
                $log->out("updating table $table");
                do_update_table(PPC, $table, { mgid__dont_quote => $mgid_pid_case }, where => {
                    mgid => $chunk,
                });
            }
        };
    };
}

$log->out('FINISH');

