#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 час',
  comment => 'исправляем значения "ни одна кампания клиента не показывалась в течение 7 дней подряд" в помесячной оффлайн статистике'
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Yandex::DateTime;
use ReportsOffline;
use Yandex::HashUtils;

use utf8;

$log->out('START');

# дата, когда выложили код, приведший к ошибке
my $DEPLOY_DATE = '2012-11-12';

# значения за месяц считаются в первых числах следующего месяца и записываются первым числом месяца, за который посчитана статистика
my ($deploy_date_first_day_of_month) = ReportsOffline::get_first_n_last_date_of_month(date($DEPLOY_DATE));

$log->out("Fetching aggregated records to fix since $deploy_date_first_day_of_month");
my $stat_to_fix = get_all_sql(MONITOR, ['SELECT ClientID, AgencyID, stat_date, client_is_7day_stopped FROM agency_clients_month_stat', WHERE => {stat_date__ge => $deploy_date_first_day_of_month}]);
my $total_rows_cnt = scalar(@$stat_to_fix);
$log->out("Got $total_rows_cnt aggregated records to fix");
my $processed_rows_cnt = 0;
for my $stat_row (@$stat_to_fix) {
    $log->out("Progress: $processed_rows_cnt/$total_rows_cnt (" . $processed_rows_cnt*100/$total_rows_cnt . ' %)') if $processed_rows_cnt % 100 == 0;
    my $stat_row_key = hash_cut($stat_row, qw/ClientID AgencyID stat_date/);
    my ($date_from, $date_to) = ReportsOffline::get_first_n_last_date_of_month(date($stat_row->{stat_date}));
    $log->out('Recalculating client_is_7day_stopped value with params: ', {%$stat_row_key, date_from => $date_from, date_to => $date_to});
    my $order_ids = get_one_column_sql(PPC_HEAVY, ["
                                     select c.OrderID
                                     from campaigns c
                                       join users u on c.uid = u.uid
                                       join users ua on c.AgencyUID = ua.uid
                                    "
                                    , where => {'ua.ClientID' => $stat_row->{AgencyID}, 'u.ClientID' => $stat_row->{ClientID}}
                                    , "
                                       and OrderID > 0
                                       and sum > 0
                                       and AgencyUID > 0
                                       and lastShowTime >= ?
                                       and c.type = 'text'
                                       and c.statusEmpty = 'No'
                                    "], $date_from) || [];

    my $client_is_7day_stopped = ReportsOffline::client_is_7day_stopped($order_ids, $date_from, $date_to);
    $log->out("New client_is_7day_stopped value is $client_is_7day_stopped (was $stat_row->{client_is_7day_stopped})");
    if ($stat_row->{client_is_7day_stopped} ne $client_is_7day_stopped) {
        do_update_table(MONITOR, 'agency_clients_month_stat', {client_is_7day_stopped => $client_is_7day_stopped}, where => $stat_row_key);
    }
    $processed_rows_cnt++;
}

$log->out('FINISH');
