#!/usr/bin/perl

=head1 DESCRIPTION

    20130228_fill_retargeting_pid.pl

=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'sql',
        webstop => 0,
        db => "ppc",
        when => 'before',
        time_estimate => "0.32 sec",
        sql => "ALTER TABLE bids_retargeting ADD COLUMN pid int(10) unsigned NOT NULL DEFAULT 0, ADD KEY pid(pid)",
        comment => "перенос ретаргетинга на группу"
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => '20 сек',
        comment => 'перенос ретаргетинга на группу(заполннеие связей bids_retargeting.pid)'
    }
]    

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Getopt::Long;

use Settings;
use Yandex::DBTools;
use Yandex::HashUtils;
use Yandex::ListUtils qw/chunks/;
use ScriptHelper;

GetOptions(
    'help' => \&usage
);

$log->out('start');
my $retargetings = get_retargetings();
fill_relations($retargetings);
$log->out('finish');

sub fill_relations {
    
    my $retargetings = shift;
    
    my @bids = sort {$a <=> $b} keys %$retargetings;
    foreach my $chunk (chunks(\@bids, 500)) {
        do_update_table(PPC, 'bids_retargeting', {
            modtime__dont_quote => 'modtime',
            pid__dont_quote => sql_case(PPC, 'bid' => hash_cut($retargetings, $chunk), default => 0)
        }, where => {bid => $chunk});
        $log->out("updated bids: " . join ',', map {$_ . '-' . $retargetings->{$_}}  @$chunk);
    }
}

sub get_retargetings {
    
    return get_hash_sql(PPC, "
        SELECT
            b.bid, b.pid
        FROM
            bids_retargeting br
            JOIN banners b USING(bid)
        GROUP BY
            b.bid");
}
