#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 секунда",
  comment => "Удаляем существующие баннерные картинки, т.к. их формат не совместим с новым"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use BannerImages;

use utf8;

$log->out('START');

my $bids = get_one_column_sql(PPC, "select bid from banner_images");

for my $bid (@$bids) {
    $log->out("remove image for banner bid = $bid");
    BannerImages::banner_remove_image($bid);
}

$log->out('FINISH');

