#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '15 секунда',
  comment => 'переотправляем письма о заявках на медиапланы, сломавшиеся с мультивалютными константами
перед запуском нужно сделать
scp ppcdev.yandex.ru:/tmp/20130322_resend_media_request_letters_data.json /tmp/20130322_resend_media_request_letters_data.json
',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use Primitives;
use GeoTools;
use MailService;
use YandexOffice;
use Yandex::IDN qw/is_valid_email/;
use JSON;
use File::Slurp;

use utf8;

# в файле хранятся сериализованные в json начения vars ($VAR4), переданные в send_prepared_mail упавших писем
# выдраны из писем в ppc-admin@
my $DATAFILE = '/tmp/20130322_resend_media_request_letters_data.json';

$log->out('START');

my $source_data_json = read_file($DATAFILE);
my $source_data = decode_json($source_data_json);

my $i = 0;
for my $vars (@$source_data) {
    $i++;
    $log->out("Processing failed mail $i");
    resend_media_request_mail($vars);
}

$log->out('FINISH');

# код большей частью взят из DoCmdMediaplan::cmd_sendRequestMediaplan
sub resend_media_request_mail {
    my ($vars) = @_;

    my $dbh = get_dbh(PPC);
    my %FORM = %{$vars->{FORM}};
    my $UID = get_one_field_sql(PPC, ['SELECT ManagerUID FROM mediaplan_stats WHERE', {cid => $FORM{cid}}]);
    my $uid = $FORM{uid};

    my $planning_email = 'planning@yandex-team.ru';
    my $planning_reg_email = 'planning_reg@yandex-team.ru';

    my $mailto = $FORM{mailto} || $planning_email;
    my $mail_from = get_manager_email($UID);

    # Если менеджер региональный, то отправляем заявку на planning_reg@yandex-team.ru
    if (get_manager_office($UID)->{office_id} != YandexOffice::get_default_office()->{office_id}){
        $mailto = $planning_reg_email;
    }
    my $from = {email => $mail_from, name => $FORM{manager_fio} ? $FORM{manager_fio} : 'Direct'};
    my $to   = ($FORM{copy_email}) ? {to => $mailto, cc => $FORM{copy_email}} : $mailto;

    # получаем контактные данные пользователя
    my $user_info = get_user_info($dbh, $uid);
    $vars->{client_login} = $user_info->{login};
    $vars->{client_fio} = $user_info->{fio};
    $vars->{client_email} = $user_info->{email};

    $vars->{get_geo_names} = \&get_geo_names; 

    send_prepared_mail($dbh, 'media_request', $to, $from, $vars);

    if ($FORM{manager_email} && is_valid_email($FORM{manager_email})) {
        send_prepared_mail($dbh, 'media_request', $FORM{manager_email}, $from, $vars);
    }
}
