#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '5 секунд',
        comment => 'Обновляем и добавляем оптовые МКБ'
    }

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Tools;
use Yandex::DBTools;
use ScriptHelper;
use Mcb;

binmode STDERR, ':utf8';

$log->{tee} = is_beta();
$log->out('START');

while (<DATA>) {
    chomp;
    my ($name, $shows, $cpm, $cost, $old_product_id, $new_product_id, $phrases) = split /\t/, $_;
    my $parent_name;
    $name =~ s/^"|"$//g;
    { # localize $1
        $name =~ s/^(.+?)\.\s*//;
        $parent_name = $1 || $name;
    }
    s/^\s*|\s*$//g for ($name, $parent_name);
    s/\D//g for ($shows, $cpm, $cost, $old_product_id, $new_product_id);
    my @phrases = split /\s*,\s*/, $phrases;
    my $theme_id = Mcb::create_theme($parent_name, $name, \@phrases);
    $log->out("created theme $parent_name/$name id = $theme_id");
    my $product_exists = get_one_field_sql(PPC, "select ProductID from products where ProductID = ?", $new_product_id);
    if ($product_exists) {
        $log->out("deleting existing product $new_product_id");
        do_delete_from_table(PPC, "products", where => { ProductID => $new_product_id });
    }
    $log->out("inserting product # $new_product_id");
    do_insert_into_table(PPC, 'products', 
        {
          'EngineID'    => '77',
          'NDS'         => '0',
          'Price'       => $cost/30,
          'Rate'        => '1',
          'UnitName'    => 'Bucks',
          'daily_shows' => '0',
          'ProductID'   => $new_product_id,
          'product_name' => "МКБ - Пакеты",
          'theme_id'    => $theme_id,
          'type'        => 'mcb_pkg',
          'packet_size' => $shows,
          'currency'    => "YND_FIXED",
        },
        on_duplicate_key_update => 1,
    );
}

Mcb::update_product_daily_shows();

$log->out('FINISH');


#Категория / Пакет 	Объем пакета (показы)	CPM	Стоимость пакета (руб.)	ID продукта старый	ID продукта новый   Фразы
__DATA__
Спорт 	1,000,000	200	200,000	new	503,214	asics, body sculpture, body solid, bodysolid, eco food, finnlo, fitnes, fitness, healthy food, ifitness, inter sport, intersport, jetstream, kant, kbiybq dtc, ketler, kettler, lbtnf, marina club, new balance, parabody, speedo, sport master, sportmaster, super gym, torneo, tunturi, world class, аквааэробика, аминокислоты, арт спорт, асикс, аэробика -реферат, беговая дорожка, боди билдинг, бодибилдинг -порно, боксерская груша, боксерские перчатки, борцовки, бутсы, бутцы -оливер, буцы -александр -золотая, век спорта, велотренажер, велоэргометр, гантели, гиперэкстензия, груша мешок, груша напольная, груши для бокса, дворец спорта, диета, диетическое, диетолог, дыхательная гимнастика, жиросжигатели, заниматься спортом -голые, занятия спортом, здоровая пища, здоровые продукты, избыточный вес, икс фит, интер спорт, интерспорт, карнитин, каток -гладильные -щель -дорожный -ручной -опорный -газон -грунтовый -асфальтовый -андрей -машинист -вибрационный -hamm -самоходный -александр, корекция веса, коррекция веса, корт -фуд, кросовки, кроссовки, лечебное питание, лечебные продукты, лишний вес, магазин кант, марина клаб, мир спорта, мяч -забитые -смотреть -обладатели -золотой, натуральные пища, натуральные продукты, ожирение, органическая еда, органическая пища, органическое питание, органическое продукты, перчатки для бокса, пилатес, питание натуральное, питание спортивное, питание тренировки, питание элитное, позудение, полезное еда, полезное питание, полезное продукты, полезные продукты, похудание, похудение, похудеть, правильное питание, пресс скамьи, профи спорт, раздельное питание, рациональное питание, сбалансированное питание, сбросить вес, свободные веса, сжигатель жира, силовая скамья, силовой комплекс, силовые центры, снаряжение, снижение веса, спорт зал, спорт клуб, спорт костюм, спорт магазин, спорт мастер, спорт товары, спортзал, спортивная гимнастика, спортивная одежда, спортивные секции, спортивные товары, спортивный зал, спортивный инвентарь, спортивный клуб, спортивный комплекс, спортивный костюм, спортивный магазин, спортивный центр, спортинвентарь, спортклуб, спорткомплекс, спорткостюм, спортмагазин, спортмастер, спортодежда, спортсекции, спортсити, спорттовары, спортцентр, тренажер, тренажерны, тренажорны, тренажорный, тренажоры, треножоры, триал спорт, турник, упражнения -английский, утренняя гимнастика, фигура -городки -шахматы -шахматные -объёмные -геометрические -восковые -площадь -пилотажа -речи -надувные -музей, фитнес -игры -ферб -смотреть -онлайн, фитнесклуб, фитнесмания, фитнесс, фитнесцентр, фиттнес, функциональное питание, шведская стенка, шейпинг -реферат, штанга -озеров -гол -хуй, экиперовка, экипировка, эко еда, эко продукты, экологическое еда, экологическое питание, экологическое продукты, элитная еда, элитная продукты
