#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 мин",
  comment => "Исправление статусов медиаплана. Медиаплан в статусе завершен, а баннеров в медиаплане нет (в таком случае статус должен быть None)",
}

=cut

use strict;
use warnings;
use utf8;


use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Mediaplan;

# SELECT count(DISCTINCT co.cid) => 263
my $cids = get_one_column_sql(PPC_HEAVY,
                "SELECT DISTINCT co.cid
                FROM camp_options co
                    LEFT JOIN mediaplan_banners mb USING(cid)
                WHERE co.mediaplan_status = 'Complete' AND mb.cid IS NULL");
                
$log->out('start');
$log->out('selected ' . scalar(@$cids) . ' mediaplans');
my $sql = 'SELECT mediaplan_status FROM camp_options WHERE cid = ?'; 
for my $cid (@$cids) {
    
    if (get_one_field_sql(PPC, $sql, $cid) eq 'Complete'
        && !get_mediaplan_banners_count($cid)) {
            
        do_update_table(PPC, 'camp_options', {mediaplan_status => 'None'},
                                where => {cid => $cid});
        $log->out("updated mediaplan status cid - " . $cid);
    }
}
$log->out('finish');
