#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 минут?",
  comment => "переливаем баннерные картинки из нашей базы в Аватарницу;
  С ключом --test N - перельет в аватарницу N картинок, без переотправки в БК
  С ключом --cid <cid1,cid2,...> - перельет и переотправит только для указаных кампаний
  "
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use BannerImages;
use Yandex::HashUtils qw/hash_cut/;
use Getopt::Long;
use Time::HiRes qw/sleep/;
use JSON;
use Yandex::Avatars;

use utf8;

$log->out('START');

GetOptions(\my %opt,
    "test=i",
    "cid=s",
);
my $test_cnt = 0;

#use Yandex::HTTP 'http_get';
#my $img = http_get('https://direct.yandex.ru/image-files/?image=lZ9VyDwGVLUTxn3a9Su2aw');
#BannerImages::banner_check_save($img);
#avatars_put('lZ9VyDwGVLUTxn3a9Su2aw' => $img);

my @cids = grep { /^\d+$/ } split /\s*,\s*/, ($opt{cid}||'');

$log->out({ cids => \@cids }) if @cids;
$log->out("selecting images");
my $images;
if (@cids) {
    $images = get_one_column_sql(PPC, [ "select distinct image_hash from banner_images bim join banners b using(bid)",
        where => { cid => \@cids } ]
    );
}
else {
    $images = get_one_column_sql(PPC, [ "select distinct image_hash from banner_images"]);
}

$log->out({ selected => scalar @$images });

my @resend;
my $resend_cnt = 0;
for my $image (@$images) {
    my $data = BannerImages::_im_data_by_hash($image);
    unless ($data) {
        $log->out("missing data for image $image");
        next;
    }
    my $formats_json = get_one_field_sql(PPC, "select formats from banner_images_formats where image_hash = ?", $image);
    if ($formats_json) {
        my $formats = from_json($formats_json);
        my %xy_name = ( x => 'width', y => 'height' );
        XY: for my $xy (qw/x y/) {
            for my $size ( 80, 90 ) {
                my $id = $xy.$size;
                if ($formats->{$id}->{$xy_name{$xy}} != $size) {
                    $log->out("Removing image '$image' from avatars: format $id is invalid ($formats_json)");
                    avatars_delete($image);
                    do_delete_from_table(PPC, 'banner_images_formats', where => { image_hash => $image });
                    last XY;
                }
            }
        }
    }
    BannerImages::save_image_avatars({ md5 => $image, img => $data });
    unless ($opt{test}) {
        push @resend, $image;
        if (@resend > 1000) {
            $resend_cnt += resend_banners(\@resend);
            @resend = ();
        }
    }
    $log->out($image);
    $test_cnt++;
    if ($opt{test} && $test_cnt >= $opt{test}) {
        last;
    }
}
if (@resend) {
    $resend_cnt += resend_banners(\@resend);
}

$log->out("total $resend_cnt banners to resend");

$log->out('FINISH');
exit;

sub resend_banners
{
    my $hashes = shift;
    my $resend_cnt = +do_insert_select_sql(PPC, "insert ignore into bs_resync_queue (cid, bid, pid) values %s",
        [ "select b.cid, b.bid, b.pid from banner_images bim join banners b using(bid)",
            where => { image_hash => $hashes } ]
    );
    $log->out("resend: $resend_cnt banners");
    return $resend_cnt;
}


