#!/usr/bin/perl

=head1 DEPLOY

# approved by mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "~ 3min",
  comment => "в табличку mediaplan_bids писались place=1 при том, что валидный значени 1..3. таких фраз примерно 1200000. Скрипт можно останавливать и перезапускать",
}

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out('start');
while(1) {
    my $mediaplan_bids = get_one_column_sql(PPC, "SELECT id from mediaplan_bids where place = 0 limit 10000");
    last if ! $mediaplan_bids;
    do_update_table(PPC, 'mediaplan_bids', {place => 1}, where => {id => $mediaplan_bids});
    $log->out(scalar @$mediaplan_bids, "records updated");
    sleep 1;
}
$log->out('finish');
